/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.ui.internal.preferences.AptConfigurationBlock;
import org.eclipse.jdt.apt.ui.internal.preferences.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProcessorOptionInputDialog
extends StatusDialog {
    private final StringDialogField fKeyField;
    private final StringDialogField fValueField;
    private final List<String> fExistingNames;

    public ProcessorOptionInputDialog(Shell parent, AptConfigurationBlock.ProcessorOption option, List<AptConfigurationBlock.ProcessorOption> existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList<String>(existingEntries.size());
        for (AptConfigurationBlock.ProcessorOption o : existingEntries) {
            if (o.equals(option)) continue;
            this.fExistingNames.add(o.key);
        }
        if (option == null) {
            this.setTitle(Messages.ProcessorOptionInputDialog_newProcessorOption);
        } else {
            this.setTitle(Messages.ProcessorOptionInputDialog_editProcessorOption);
        }
        FieldAdapter adapter = new FieldAdapter();
        this.fKeyField = new StringDialogField();
        this.fKeyField.setLabelText(Messages.ProcessorOptionInputDialog_key);
        this.fKeyField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fValueField = new StringDialogField();
        this.fValueField.setLabelText(Messages.ProcessorOptionInputDialog_value);
        this.fValueField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fKeyField.setText(option != null ? option.key : "");
        this.fValueField.setText(option != null ? option.value : "");
    }

    public AptConfigurationBlock.ProcessorOption getResult() {
        AptConfigurationBlock.ProcessorOption option = new AptConfigurationBlock.ProcessorOption();
        option.key = this.fKeyField.getText().trim();
        option.value = this.fValueField.getText().trim();
        return option;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fKeyField.doFillIntoGrid(inner, 2);
        this.fValueField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fKeyField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fKeyField.getTextControl(null), (int)this.convertWidthInCharsToPixels(50));
        LayoutUtil.setHorizontalGrabbing((Control)this.fValueField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fValueField.getTextControl(null), (int)this.convertWidthInCharsToPixels(50));
        this.fKeyField.postSetFocusOnDialogField(parent.getDisplay());
        ProcessorOptionInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newKey = this.fKeyField.getText();
        String newVal = this.fValueField.getText();
        if (newKey.length() == 0) {
            status.setError(Messages.ProcessorOptionInputDialog_emptyKey);
        } else if (this.fExistingNames.contains(newKey)) {
            status.setError(Messages.ProcessorOptionInputDialog_keyAlreadyInUse);
        } else if (newVal.indexOf(61) >= 0) {
            status.setError(Messages.ProcessorOptionInputDialog_equalsSignNotValid);
        } else if (AptConfig.isAutomaticProcessorOption((String)newKey)) {
            status.setWarning(Messages.AptConfigurationBlock_warningIgnoredOptions);
        }
        this.updateStatus((IStatus)status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.apt.ui.processor_option_input_dialog_context");
    }

    private class FieldAdapter
    implements IDialogFieldListener {
        private FieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            ProcessorOptionInputDialog.this.doValidation();
        }
    }
}

