/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.ConvertedToEMFPipe;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.util.ECLBinaryResourceImpl;
import org.eclipse.rcptt.ecl.internal.core.EMFConverterManager;
import org.eclipse.rcptt.ecl.internal.core.IMarkeredPipe;
import org.eclipse.rcptt.ecl.runtime.IPipe;

public class EMFStreamPipe
implements IPipe,
IMarkeredPipe {
    private static final int CLOSE_PIPE_ID = 123;
    private static final int OBJECT_ID = 121;
    private final DataInputStream in;
    private final DataOutputStream out;
    private boolean closed = false;

    public EMFStreamPipe(InputStream in, OutputStream out) {
        this.in = new DataInputStream(in);
        this.out = new DataOutputStream(out);
    }

    @Override
    public void reinit() {
        this.closed = false;
    }

    @Override
    public void writeCloseMarker() throws CoreException {
        this.writeStatus(123);
    }

    @Override
    public void closeNoWait() {
        this.closed = true;
    }

    @Override
    public IPipe close(IStatus status) throws CoreException {
        if (!this.closed) {
            this.closed = true;
            try {
                byte kind = this.in.readByte();
                if (123 != kind) {
                    Exception e = new Exception("Failed to close emf pipe");
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", e.getMessage() + "  ---- close", (Throwable)e));
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", e.getMessage() + "  ---- close", (Throwable)e));
            }
        }
        return this;
    }

    @Override
    public Object take(long timeout) throws CoreException {
        byte kind;
        byte[] data;
        int size;
        ECLBinaryResourceImpl r;
        block8: {
            if (this.closed) {
                return null;
            }
            r = new ECLBinaryResourceImpl();
            size = 0;
            data = null;
            try {
                kind = this.in.readByte();
                if (123 != kind) break block8;
                this.closed = true;
                return null;
            }
            catch (Throwable e) {
                if (e instanceof EOFException) {
                    return new Status(4, "org.eclipse.rcptt.ecl.core", "Connection is not Available", e);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", e.getMessage(), e));
            }
        }
        if (121 != kind) {
            throw new IOException("Failed to read object from stream");
        }
        size = this.in.readInt();
        if (size <= 0) {
            throw new IOException("Failed to read from stream");
        }
        data = new byte[size];
        this.in.readFully(data);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        r.load(bin, this.getOptions());
        EObject eObject = (EObject)r.getContents().get(0);
        if (eObject instanceof ConvertedToEMFPipe) {
            return EMFConverterManager.INSTANCE.fromEObject(((ConvertedToEMFPipe)eObject).getObject());
        }
        return eObject;
    }

    private Map<String, Object> getOptions() {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        return opts;
    }

    @Override
    public IPipe write(Object object) throws CoreException {
        EObject eObject;
        if (object instanceof EObject) {
            eObject = (EObject)object;
        } else {
            ConvertedToEMFPipe converted = CoreFactory.eINSTANCE.createConvertedToEMFPipe();
            converted.setObject(EMFConverterManager.INSTANCE.toEObject(object));
            eObject = converted;
        }
        ECLBinaryResourceImpl r = new ECLBinaryResourceImpl();
        r.getContents().add((Object)eObject);
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            r.save(bout, this.getOptions());
            this.out.writeByte(121);
            this.out.writeInt(bout.size());
            bout.writeTo(this.out);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", "Failed to write " + String.valueOf(object), (Throwable)e));
        }
        return this;
    }

    private void writeStatus(int status) throws CoreException {
        try {
            this.out.writeByte(status);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", e.getMessage() + "  ---- " + status, (Throwable)e));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

