/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.InstallableUnitProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.Messages;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.Node;
import org.eclipse.pde.internal.genericeditor.target.extension.model.RepositoryCache;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;

public class AttributeValueCompletionProcessor
extends DelegateProcessor {
    private final String searchTerm;
    private final String acKey;
    private final int offset;

    public AttributeValueCompletionProcessor(String searchTerm, String acKey, int offset) {
        this.searchTerm = searchTerm;
        this.acKey = acKey;
        this.offset = offset;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        LocationNode location;
        Object object;
        Parser parser = Parser.getDefault();
        Node rootNode = parser.getRootNode();
        if (rootNode == null) {
            return new ICompletionProposal[0];
        }
        List<Node> locationsNode = rootNode.getChildNodesByTag("locations");
        if (locationsNode == null || locationsNode.isEmpty()) {
            return new ICompletionProposal[0];
        }
        Node locationNode = null;
        for (Node u : locationsNode.get(0).getChildNodesByTag("location")) {
            if (this.offset < u.getOffsetStart() || this.offset >= u.getOffsetEnd()) continue;
            locationNode = u;
            break;
        }
        if (locationNode == null) {
            return new ICompletionProposal[0];
        }
        Node node = null;
        for (Node u : locationNode.getChildNodesByTag("unit")) {
            if (this.offset < u.getOffsetStart() || this.offset >= u.getOffsetEnd()) continue;
            node = (UnitNode)u;
            break;
        }
        if ("id".equalsIgnoreCase(this.acKey) && node != null) {
            Node u;
            object = node.getParentNode();
            if (!(object instanceof LocationNode)) {
                return this.getErrorCompletion();
            }
            u = (LocationNode)object;
            List<String> repoLocations = location.getRepositoryLocations();
            if (repoLocations.isEmpty()) {
                return this.getErrorCompletion();
            }
            Map<String, List<IVersionedId>> units = RepositoryCache.fetchP2UnitsFromRepos(repoLocations);
            return this.toProposals(units.keySet().stream());
        }
        if ("version".equalsIgnoreCase(this.acKey) && node != null) {
            object = node.getParentNode();
            if (!(object instanceof LocationNode)) {
                return this.getErrorCompletion();
            }
            location = (LocationNode)object;
            List<String> repoLocations = location.getRepositoryLocations();
            if (repoLocations.isEmpty()) {
                return this.getErrorCompletion();
            }
            Map<String, List<IVersionedId>> units = RepositoryCache.fetchP2UnitsFromRepos(repoLocations);
            List<IVersionedId> versions = units.get(((UnitNode)node).getId());
            if (versions != null) {
                Stream<String> availableVersions = Stream.concat(versions.stream().map(unit -> unit.getVersion().toString()), Stream.of("0.0.0"));
                return this.toProposals(availableVersions.distinct());
            }
        }
        if ("location".equalsIgnoreCase(this.acKey)) {
            List<URI> children = RepositoryCache.fetchChildrenOfRepo(this.searchTerm);
            return this.toProposals(children.stream().map(URI::toString));
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] toProposals(Stream<String> values) {
        return (ICompletionProposal[])values.map(value -> TargetDefinitionContentAssist.getFilteredStyledString(value, this.searchTerm)).filter(displayString -> displayString != null && !displayString.isEmpty()).map(string -> new InstallableUnitProposal((StyledString)string, this.offset - this.searchTerm.length(), this.searchTerm.length())).toArray(ICompletionProposal[]::new);
    }

    private ICompletionProposal[] getErrorCompletion() {
        String replacementString = Messages.AttributeValueCompletionProcessor_RepositoryRequired;
        return new ICompletionProposal[]{new CompletionProposal("", this.offset, 0, 0, null, replacementString, null, null)};
    }
}

