/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlayAction;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceShortcutUtil;

class AccessibleToolItem {
    private final ToolItem toolItem;
    private FindReplaceOverlayAction action = new FindReplaceOverlayAction(null);

    AccessibleToolItem(Composite parent, int styleBits) {
        ToolBar toolbar = new ToolBar(parent, 0x800100);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)toolbar);
        this.toolItem = new ToolItem(toolbar, styleBits);
        this.addToolItemTraverseListener(toolbar);
    }

    private void addToolItemTraverseListener(ToolBar parent) {
        parent.addTraverseListener(e -> {
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                this.action.execute();
                e.doit = false;
            }
        });
    }

    ToolItem getToolItem() {
        return this.toolItem;
    }

    void setBackground(Color color) {
        this.toolItem.getParent().setBackground(color);
    }

    void setImage(Image image) {
        this.toolItem.setImage(image);
    }

    void setToolTipText(String text) {
        this.toolItem.setToolTipText(this.action.addShortcutHintToTooltipText(text));
    }

    void setOperation(Runnable operation, List<KeyStroke> shortcuts) {
        boolean isCheckbox = (this.toolItem.getStyle() & 0x20) != 0;
        this.action = isCheckbox ? new FindReplaceOverlayAction(() -> {
            this.toolItem.setSelection(!this.toolItem.getSelection());
            operation.run();
        }) : new FindReplaceOverlayAction(operation);
        this.action.addShortcuts(shortcuts);
        this.setToolTipText(this.toolItem.getToolTipText());
        this.toolItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(__ -> operation.run()));
    }

    void registerActionShortcutsAtControl(Control control) {
        FindReplaceShortcutUtil.registerActionShortcutsAtControl(this.action, control);
    }
}

