/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import org.eclipse.jetty.logging.JettyLoggerConfiguration;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.IMarkerFactory;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class JettyLoggingServiceProvider
implements SLF4JServiceProvider {
    private static final String REQUESTED_API_VERSION = "2.0";
    private JettyLoggerFactory loggerFactory;
    private BasicMarkerFactory markerFactory;
    private MDCAdapter mdcAdapter;

    public void initialize() {
        JettyLoggerConfiguration config = new JettyLoggerConfiguration().load(this.getClass().getClassLoader());
        this.loggerFactory = new JettyLoggerFactory(config);
        this.markerFactory = new BasicMarkerFactory();
        this.mdcAdapter = new NOPMDCAdapter();
    }

    public JettyLoggerFactory getJettyLoggerFactory() {
        return this.loggerFactory;
    }

    public ILoggerFactory getLoggerFactory() {
        return this.getJettyLoggerFactory();
    }

    public IMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    public String getRequestedApiVersion() {
        return REQUESTED_API_VERSION;
    }
}

