/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.registry.IActionSet;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class ActionPresentation {
    private WorkbenchWindow window;
    private Map<IActionSetDescriptor, SetRec> mapDescToRec = new HashMap<IActionSetDescriptor, SetRec>(3);
    private Map<IActionSetDescriptor, SetRec> invisibleBars = new HashMap<IActionSetDescriptor, SetRec>(3);

    public ActionPresentation(WorkbenchWindow window) {
        this.window = window;
    }

    public void clearActionSets() {
        ArrayList<IActionSetDescriptor> oldList = new ArrayList<IActionSetDescriptor>();
        oldList.addAll(this.mapDescToRec.keySet());
        oldList.addAll(this.invisibleBars.keySet());
        for (IActionSetDescriptor desc : oldList) {
            this.removeActionSet(desc);
        }
    }

    public void removeActionSet(IActionSetDescriptor desc) {
        SetRec rec = this.mapDescToRec.remove(desc);
        if (rec == null) {
            rec = this.invisibleBars.remove(desc);
        }
        if (rec != null) {
            IActionSet set = rec.set;
            SubActionBars bars = rec.bars;
            if (bars != null) {
                bars.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    public void setActionSets(IActionSetDescriptor[] newArray) {
        HashSet<IActionSetDescriptor> newList = new HashSet<IActionSetDescriptor>();
        newList.addAll(Arrays.asList(newArray));
        ArrayList<IActionSetDescriptor> oldList = new ArrayList<IActionSetDescriptor>(this.mapDescToRec.keySet());
        for (IActionSetDescriptor desc : oldList) {
            SetRec rec;
            if (newList.contains(desc) || (rec = this.mapDescToRec.get(desc)) == null) continue;
            this.mapDescToRec.remove(desc);
            IActionSet set = rec.set;
            SubActionBars bars = rec.bars;
            if (bars == null) continue;
            SetRec invisibleRec = new SetRec(set, bars);
            this.invisibleBars.put(desc, invisibleRec);
            bars.deactivate();
        }
        ArrayList<PluginActionSet> sets = new ArrayList<PluginActionSet>();
        IActionSetDescriptor[] iActionSetDescriptorArray = newArray;
        int n = newArray.length;
        int set = 0;
        while (set < n) {
            IActionSetDescriptor desc = iActionSetDescriptorArray[set];
            if (!this.mapDescToRec.containsKey(desc)) {
                try {
                    SetRec rec;
                    if (this.invisibleBars.containsKey(desc)) {
                        rec = this.invisibleBars.get(desc);
                        if (rec.bars != null) {
                            rec.bars.activate();
                        }
                        this.invisibleBars.remove(desc);
                    } else {
                        IActionSet set2 = desc.createActionSet();
                        ActionSetActionBars bars = new ActionSetActionBars(this.window.getActionBars(), this.window, (IActionBarConfigurer2)this.window.getWindowConfigurer().getActionBarConfigurer(), desc.getId());
                        rec = new SetRec(set2, bars);
                        set2.init(this.window, bars);
                        if (set2 instanceof PluginActionSet) {
                            PluginActionSet pluginActionSet = (PluginActionSet)set2;
                            sets.add(pluginActionSet);
                        } else {
                            String pattern = "Ignored unexpected IActionSet implementation for descriptor {0}: {1}";
                            WorkbenchPlugin.log(NLS.bind((String)pattern, (Object)desc.getId(), (Object)set2));
                        }
                        Object[] existingRegistrations = this.window.getExtensionTracker().getObjects(desc.getConfigurationElement().getDeclaringExtension());
                        if (existingRegistrations.length == 0 || !this.containsRegistration(existingRegistrations, desc)) {
                            this.window.getExtensionTracker().registerObject(desc.getConfigurationElement().getDeclaringExtension(), (Object)desc, 2);
                        }
                    }
                    this.mapDescToRec.put(desc, rec);
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to create ActionSet: " + desc.getId(), e);
                }
            }
            ++set;
        }
        PluginActionSetBuilder.processActionSets(sets, this.window);
        for (PluginActionSet set3 : sets) {
            set3.getBars().activate();
        }
    }

    private boolean containsRegistration(Object[] existingRegistrations, IActionSetDescriptor set) {
        Object[] objectArray = existingRegistrations;
        int n = existingRegistrations.length;
        int n2 = 0;
        while (n2 < n) {
            Object existingRegistration = objectArray[n2];
            if (existingRegistration == set) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IActionSet[] getActionSets() {
        Collection<SetRec> setRecCollection = this.mapDescToRec.values();
        IActionSet[] result = new IActionSet[setRecCollection.size()];
        int i = 0;
        Iterator<SetRec> iterator = setRecCollection.iterator();
        while (iterator.hasNext()) {
            result[i] = iterator.next().set;
            ++i;
        }
        return result;
    }

    private static class SetRec {
        public IActionSet set;
        public SubActionBars bars;

        public SetRec(IActionSet set, SubActionBars bars) {
            this.set = set;
            this.bars = bars;
        }
    }
}

