/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.lang.ref.SoftReference;
import java.util.Arrays;

public class CharDeduplication {
    private static final char[] CHAR_ARRAY0 = new char[0];
    static final char[][] ASCII_CHARS = new char[128][];
    public static final int TABLE_SIZE = 8192;
    public static final int SEARCH_SIZE = 8;
    private static final ThreadLocal<SoftReference<CharDeduplication>> mutableCache;
    private final char[][] hashTable = new char[8192][];
    private final int[] circularBufferPointer = new int[8192];

    static {
        int i = 0;
        while (i < ASCII_CHARS.length) {
            CharDeduplication.ASCII_CHARS[i] = new char[]{(char)i};
            ++i;
        }
        mutableCache = ThreadLocal.withInitial(() -> new SoftReference<CharDeduplication>(new CharDeduplication()));
    }

    public static CharDeduplication getThreadLocalInstance() {
        CharDeduplication local = mutableCache.get().get();
        if (local == null) {
            local = new CharDeduplication();
            mutableCache.set(new SoftReference<CharDeduplication>(local));
        }
        return local;
    }

    private CharDeduplication() {
    }

    @Deprecated
    public void reset() {
        Arrays.fill((Object[])this.hashTable, null);
        Arrays.fill(this.circularBufferPointer, 0);
    }

    public static char[] intern(char[] source) {
        return CharDeduplication.getThreadLocalInstance().sharedCopyOfRange(source, 0, source.length);
    }

    public char[] sharedCopyOfRange(char[] source, int from, int to) {
        int length = to - from;
        switch (length) {
            case 1: {
                char charOne = source[from];
                if (charOne >= ASCII_CHARS.length) break;
                return ASCII_CHARS[charOne];
            }
            case 0: {
                return CHAR_ARRAY0;
            }
        }
        int hash = this.hashCode(source, from, to);
        int circularBufferStart = hash & 0x1FFF;
        int positionToReplace = -1;
        int i = 0;
        while (i < 8) {
            int position = circularBufferStart + i & 0x1FFF;
            char[] charArray = this.hashTable[position];
            if (charArray == null) {
                positionToReplace = position;
            } else if (this.equals(source, from, to, charArray)) {
                return charArray;
            }
            ++i;
        }
        char[] r = Arrays.copyOfRange(source, from, to);
        if (positionToReplace == -1) {
            int n = circularBufferStart;
            int n2 = this.circularBufferPointer[n];
            this.circularBufferPointer[n] = n2 + 1;
            int j = n2;
            positionToReplace = circularBufferStart + (j & 7) & 0x1FFF;
        }
        this.hashTable[positionToReplace] = r;
        return r;
    }

    private int hashCode(char[] source, int from, int to) {
        int result = source[from];
        int i = from + 1;
        while (i < to) {
            result = 31 * result + source[i];
            ++i;
        }
        return result;
    }

    private boolean equals(char[] source, int from, int to, char[] charArray) {
        if (charArray.length != to - from) {
            return false;
        }
        int i = from;
        while (i < to) {
            if (source[i] != charArray[i - from]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

