/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.ConfigurationAreaBlock;
import org.eclipse.pde.internal.ui.launcher.JREBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class OSGiSettingsTab
extends AbstractLauncherTab {
    private final JREBlock fJREBlock;
    private final ConfigurationAreaBlock fConfigurationBlock;
    private final Image fImage = PDEPluginImages.DESC_SETTINGS_OBJ.createImage();
    private boolean fInitializing = false;

    public OSGiSettingsTab() {
        this.fJREBlock = new JREBlock(this);
        this.fConfigurationBlock = new ConfigurationAreaBlock(this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.fJREBlock.createControl(container);
        this.fConfigurationBlock.createControl(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.launcher_configuration");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fJREBlock.setDefaults(configuration);
        this.fConfigurationBlock.setDefaults(configuration, false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fInitializing = true;
            this.fJREBlock.initializeFrom(configuration);
            this.fConfigurationBlock.initializeFrom(configuration);
            this.fInitializing = false;
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fJREBlock.performApply(configuration);
        this.fConfigurationBlock.performApply(configuration);
    }

    public String getName() {
        return PDEUIMessages.EquinoxSettingsTab_name;
    }

    public Image getImage() {
        return this.fImage;
    }

    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
        }
    }

    @Override
    public void validateTab() {
    }

    @Override
    public void updateLaunchConfigurationDialog() {
        if (!this.fInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public String getId() {
        return "org.eclipse.pde.ui.launch.tab.osgi.settings";
    }
}

