/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;

public class Category {
    private final IConfigurationElement config;
    private String[] parentCategoryPath;
    public static final String ATT_ID = "id";
    public static final String ATT_CATEGORY = "parentCategory";
    public static final String ATT_NAME = "name";

    public Category(IConfigurationElement aConfig) {
        this.config = aConfig;
    }

    public String getID() {
        return this.config.getAttribute(ATT_ID);
    }

    public String getLabel() {
        return this.config.getAttribute(ATT_NAME);
    }

    public String[] getParentCategoryPath() {
        if (this.parentCategoryPath != null) {
            return this.parentCategoryPath;
        }
        String category = this.config.getAttribute(ATT_CATEGORY);
        if (category == null) {
            return null;
        }
        StringTokenizer stok = new StringTokenizer(category, "/");
        this.parentCategoryPath = new String[stok.countTokens()];
        int i = 0;
        while (stok.hasMoreTokens()) {
            this.parentCategoryPath[i] = stok.nextToken();
            ++i;
        }
        return this.parentCategoryPath;
    }
}

