/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.bundle.BundlePlugin;
import org.eclipse.pde.internal.ui.util.ExtensionsFilterUtil;
import org.eclipse.ui.dialogs.PatternFilter;

public class ExtensionsPatternFilter
extends PatternFilter {
    public static final int ATTRIBUTE_LIMIT = 30;
    protected String fSearchPattern;
    protected Set<String> fSearchPatterns = new HashSet<String>();
    protected final Set<IPluginObject> fMatchingLeafs = new HashSet<IPluginObject>();
    protected final Set<Object> fFoundAnyElementsCache = new HashSet<Object>();

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        if (this.isNameMatch(element)) {
            return true;
        }
        if (element instanceof IPluginElement) {
            return this.doIsLeafMatch((IPluginElement)element);
        }
        return false;
    }

    protected boolean doIsLeafMatch(IPluginElement pluginElement) {
        List<String> syntheticAttributes = ExtensionsFilterUtil.handlePropertyTester(pluginElement);
        if (this.fSearchPatterns != null && !this.fSearchPatterns.isEmpty()) {
            int attributeNumber = 0;
            for (String searchPattern : this.fSearchPatterns) {
                if (attributeNumber < this.fSearchPatterns.size() && attributeNumber < 30) {
                    boolean quoted = ExtensionsPatternFilter.isQuoted(searchPattern);
                    if (searchPattern != null && searchPattern.length() > 0) {
                        if (quoted) {
                            searchPattern = searchPattern.substring(1, searchPattern.length() - 1);
                        }
                        int attributeCount = pluginElement.getAttributeCount();
                        IPluginAttribute[] elementAttributes = pluginElement.getAttributes();
                        int i = 0;
                        while (i < attributeCount) {
                            String[] attributes;
                            IPluginAttribute attributeElement = elementAttributes[i];
                            if (attributeElement != null && attributeElement.getValue() != null && (attributes = ExtensionsPatternFilter.getAttributeSplit(attributeElement.getValue(), quoted)) != null) {
                                ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList(attributes));
                                attributeList.addAll(syntheticAttributes);
                                if (this.matchWithAttributes(pluginElement, searchPattern, attributeElement.getName(), attributeList, quoted)) {
                                    return true;
                                }
                            }
                            ++i;
                        }
                        if (searchPattern.equalsIgnoreCase(pluginElement.getName())) {
                            return true;
                        }
                    }
                }
                ++attributeNumber;
            }
        }
        return false;
    }

    protected boolean isNameMatch(Object element) {
        return element != null && (element instanceof IPluginElement ? super.wordMatches(((IPluginElement)element).getName()) : element instanceof IPluginExtension && super.wordMatches(((IPluginExtension)element).getPoint()));
    }

    protected boolean matchWithAttributes(IPluginElement pluginElement, String searchPattern, String attributeName, List<String> attributeList, boolean quoted) {
        int k = 0;
        while (k < attributeList.size()) {
            String attributeValue = attributeList.get(k);
            if (attributeValue != null && attributeValue.length() > 0) {
                if (!attributeValue.startsWith("%") || quoted) {
                    int delimiterPosition = attributeValue.indexOf(63);
                    if (delimiterPosition != -1) {
                        attributeValue = attributeValue.substring(0, delimiterPosition);
                    }
                    if (attributeValue.equalsIgnoreCase(searchPattern)) {
                        return true;
                    }
                    if (!quoted && this.isNoneResourceMatch(attributeValue, attributeName, searchPattern)) {
                        return true;
                    }
                } else {
                    String resourceValue = pluginElement.getResourceString(attributeValue);
                    attributeValue = resourceValue != null && resourceValue.length() > 0 ? resourceValue : attributeValue;
                    super.setPattern(String.valueOf(searchPattern));
                    boolean match = super.wordMatches(attributeValue);
                    super.setPattern(this.fSearchPattern);
                    if (match) {
                        return true;
                    }
                }
            }
            ++k;
        }
        return false;
    }

    protected boolean isNoneResourceMatch(String attributeValue, String attributeName, String searchPattern) {
        if (ExtensionsFilterUtil.isAttributeNameMatch(attributeName, ExtensionsFilterUtil.RESOURCE_ATTRIBUTES) && attributeValue.indexOf(46) == -1 && searchPattern.indexOf(46) == -1) {
            super.setPattern(searchPattern);
            boolean match = super.wordMatches(attributeValue);
            super.setPattern(this.fSearchPattern);
            if (match) {
                return true;
            }
            super.setPattern(this.fSearchPattern);
        }
        return false;
    }

    static boolean isQuoted(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    static String[] getAttributeSplit(String text, boolean quoted) {
        if (text.length() < 2) {
            return null;
        }
        if (!quoted) {
            return text.replaceAll("/{1,}", "/").split("/");
        }
        return new String[]{text};
    }

    public boolean isElementVisible(Viewer viewer, Object element) {
        if (this.fFoundAnyElementsCache.contains(element)) {
            return true;
        }
        return this.isLeafMatch(viewer, element);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (parent != null && parent instanceof BundlePlugin && this.fFoundAnyElementsCache.isEmpty() && this.fSearchPattern != null && this.fSearchPattern.length() > 0) {
            BundlePlugin pluginPlugin = (BundlePlugin)parent;
            this.doFilter(viewer, pluginPlugin, (IPluginObject[])pluginPlugin.getExtensions(), false);
        }
        if (!this.fFoundAnyElementsCache.isEmpty()) {
            ArrayList<Object> found = new ArrayList<Object>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.fFoundAnyElementsCache.contains(element)) {
                    found.add(element);
                }
                ++n2;
            }
            return found.toArray();
        }
        return super.filter(viewer, parent, elements);
    }

    protected boolean doFilter(Viewer viewer, Object parent, IPluginObject[] children, boolean addChildren) {
        boolean isParentMatch = this.fFoundAnyElementsCache.contains(parent);
        boolean isAnyLeafMatch = false;
        IPluginObject[] iPluginObjectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject iPluginObject = iPluginObjectArray[n2];
            boolean isChildMatch = true;
            if (!isParentMatch || children.length > 0) {
                isChildMatch = this.isLeafMatch(viewer, iPluginObject);
                isAnyLeafMatch |= isChildMatch;
                if (isChildMatch) {
                    this.fMatchingLeafs.add(iPluginObject);
                }
            }
            if (isChildMatch || addChildren) {
                this.fFoundAnyElementsCache.add(iPluginObject);
            }
            ++n2;
        }
        boolean isAnyChildMatch = false;
        IPluginObject[] iPluginObjectArray2 = children;
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            IPluginParent pluginElement;
            IPluginObject iPluginObject = iPluginObjectArray2[n];
            if (iPluginObject instanceof IPluginParent && (pluginElement = (IPluginParent)iPluginObject).getChildren().length > 0) {
                boolean isChildrenMatch = this.doFilter(viewer, pluginElement, pluginElement.getChildren(), addChildren || this.fMatchingLeafs.contains(pluginElement));
                isAnyChildMatch |= isChildrenMatch;
                if (isChildrenMatch) {
                    this.fFoundAnyElementsCache.add(pluginElement);
                }
            }
            ++n;
        }
        return isAnyChildMatch || isAnyLeafMatch;
    }

    protected String[] splitWithQuoting(String filterText) {
        boolean containsQuoting;
        String text = filterText.replaceAll("/{1,}", "/");
        boolean bl = containsQuoting = text.indexOf(34) != -1;
        if (containsQuoting) {
            if ((text = text.replaceAll("\"{1,}", "\"")).replaceAll("[^\"]", "").length() % 2 == 0) {
                return text.split("/(?=([^\"]*\"[^\"]*\")*(?![^\"]*\"))");
            }
            text = text.replaceAll("[\"]", "");
        }
        return text.split("/");
    }

    public boolean addElement(Object element) {
        return this.fFoundAnyElementsCache.add(element);
    }

    public boolean removeElement(Object element) {
        return this.fFoundAnyElementsCache.remove(element);
    }

    public final void setPattern(String patternString) {
        super.setPattern(patternString);
        this.fSearchPattern = patternString;
        String[] patterns = patternString != null ? this.splitWithQuoting(patternString) : new String[]{};
        this.fSearchPatterns.clear();
        this.fSearchPatterns.addAll(Arrays.asList(patterns));
        this.fFoundAnyElementsCache.clear();
    }

    public String getPattern() {
        return this.fSearchPattern;
    }

    public void clearMatchingLeafs() {
        this.fMatchingLeafs.clear();
    }

    public Object[] getMatchingLeafsAsArray() {
        return this.fMatchingLeafs.toArray();
    }

    public Set<IPluginObject> getMatchingLeafs() {
        return this.fMatchingLeafs;
    }

    public boolean containsElement(Object element) {
        return this.fFoundAnyElementsCache.contains(element);
    }
}

