/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class SyntaxColorTab {
    protected IColorManager fColorManager;
    private TableViewer fElementViewer;
    private SourceViewer fPreviewViewer;
    private ChangeAwareSourceViewerConfiguration fSourceViewerConfiguration;
    private Button fBoldButton;
    private Button fItalicButton;
    private ColorSelector fColorSelector;

    public SyntaxColorTab(IColorManager manager) {
        this.fColorManager = manager;
    }

    protected abstract String[][] getColorStrings();

    private ColorElement[] getColorData() {
        String[][] colors = this.getColorStrings();
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        ColorElement[] list = new ColorElement[colors.length];
        int i = 0;
        while (i < colors.length) {
            String displayName = colors[i][0];
            String key = colors[i][1];
            RGB setting = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
            boolean bold = store.getBoolean(key + "_bold");
            boolean italic = store.getBoolean(key + "_italic");
            list[i] = new ColorElement(displayName, key, setting, bold, italic);
            ++i;
        }
        return list;
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createElementTable(container);
        this.createPreviewer(container);
        return container;
    }

    private void createElementTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 16384);
        label.setText(PDEUIMessages.SyntaxColorTab_elements);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fElementViewer = new TableViewer(container, 2564);
        this.fElementViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fElementViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fElementViewer.getControl().setLayoutData((Object)new GridData(1808));
        Composite colorComposite = new Composite(container, 0);
        colorComposite.setLayout((Layout)new GridLayout(2, false));
        colorComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(colorComposite, 16384);
        label.setText(PDEUIMessages.SyntaxColorTab_color);
        this.fColorSelector = new ColorSelector(colorComposite);
        Button colorButton = this.fColorSelector.getButton();
        colorButton.setLayoutData((Object)new GridData(1));
        colorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ColorElement item = this.getColorElement(this.fElementViewer);
            item.setColorValue(this.fColorSelector.getColorValue());
        }));
        this.fBoldButton = new Button(colorComposite, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fBoldButton.setLayoutData((Object)gd);
        this.fBoldButton.setText(PDEUIMessages.SyntaxColorTab_bold);
        this.fBoldButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ColorElement item = this.getColorElement(this.fElementViewer);
            item.setBold(this.fBoldButton.getSelection());
        }));
        this.fItalicButton = new Button(colorComposite, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fItalicButton.setLayoutData((Object)gd);
        this.fItalicButton.setText(PDEUIMessages.SyntaxColorTab_italic);
        this.fItalicButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ColorElement item = this.getColorElement(this.fElementViewer);
            item.setItalic(this.fItalicButton.getSelection());
        }));
        this.fElementViewer.addSelectionChangedListener(event -> {
            ColorElement item = this.getColorElement(this.fElementViewer);
            this.fColorSelector.setColorValue(item.getColorValue());
            this.fBoldButton.setSelection(item.isBold());
            this.fItalicButton.setSelection(item.isItalic());
        });
        this.fElementViewer.setInput((Object)this.getColorData());
        this.fElementViewer.setComparator(new ViewerComparator());
        this.fElementViewer.setSelection((ISelection)new StructuredSelection(this.fElementViewer.getElementAt(0)));
    }

    private void createPreviewer(Composite parent) {
        Composite previewComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        previewComp.setLayout((Layout)layout);
        previewComp.setLayoutData((Object)new GridData(1808));
        Label label = new Label(previewComp, 0);
        label.setText(PDEUIMessages.SyntaxColorTab_preview);
        label.setLayoutData((Object)new GridData(768));
        this.fPreviewViewer = new SourceViewer(previewComp, null, 2816);
        this.fSourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (this.fSourceViewerConfiguration != null) {
            this.fPreviewViewer.configure((SourceViewerConfiguration)this.fSourceViewerConfiguration);
        }
        this.fPreviewViewer.setEditable(false);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.fPreviewViewer.setDocument(this.getDocument());
        Control control = this.fPreviewViewer.getControl();
        control.setLayoutData((Object)new GridData(1808));
    }

    protected abstract ChangeAwareSourceViewerConfiguration getSourceViewerConfiguration();

    public void performOk() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        int count = this.fElementViewer.getTable().getItemCount();
        int i = 0;
        while (i < count) {
            ColorElement item = (ColorElement)this.fElementViewer.getElementAt(i);
            PreferenceConverter.setValue((IPreferenceStore)store, (String)item.getColorKey(), (RGB)item.getColorValue());
            store.setValue(item.getColorKey() + "_bold", item.isBold());
            store.setValue(item.getColorKey() + "_italic", item.isItalic());
            ++i;
        }
    }

    public void performDefaults() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        int count = this.fElementViewer.getTable().getItemCount();
        int i = 0;
        while (i < count) {
            ColorElement item = (ColorElement)this.fElementViewer.getElementAt(i);
            RGB rgb = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)item.getColorKey());
            item.setColorValue(rgb);
            item.setBold(store.getDefaultBoolean(item.getColorKey() + "_bold"));
            item.setItalic(store.getDefaultBoolean(item.getColorKey() + "_italic"));
            ++i;
        }
        ColorElement element = this.getColorElement(this.fElementViewer);
        this.fColorSelector.setColorValue(element.fColorValue);
        this.fBoldButton.setSelection(element.isBold());
        this.fItalicButton.setSelection(element.isItalic());
    }

    public void dispose() {
        this.fSourceViewerConfiguration.dispose();
    }

    protected abstract IDocument getDocument();

    private ColorElement getColorElement(TableViewer viewer) {
        IStructuredSelection selection = viewer.getStructuredSelection();
        return (ColorElement)selection.getFirstElement();
    }

    class ColorElement {
        private final String fDisplayName;
        private final String fColorKey;
        private RGB fColorValue;
        private boolean fBold;
        private boolean fItalic;

        public ColorElement(String displayName, String colorKey, RGB colorValue, boolean bold, boolean italic) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fColorValue = colorValue;
            this.fBold = bold;
            this.fItalic = italic;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public RGB getColorValue() {
            return this.fColorValue;
        }

        public void setColorValue(RGB rgb) {
            if (this.fColorValue.equals((Object)rgb)) {
                return;
            }
            RGB oldrgb = this.fColorValue;
            this.fColorValue = rgb;
            this.firePropertyChange(new PropertyChangeEvent((Object)this, this.fColorKey, (Object)oldrgb, (Object)rgb));
        }

        public void setBold(boolean bold) {
            if (bold == this.fBold) {
                return;
            }
            Boolean oldValue = this.fBold;
            this.fBold = bold;
            Boolean newValue = bold;
            String property = this.fColorKey + "_bold";
            this.firePropertyChange(new PropertyChangeEvent((Object)this, property, (Object)oldValue, (Object)newValue));
        }

        public boolean isBold() {
            return this.fBold;
        }

        public void setItalic(boolean italic) {
            if (italic == this.fItalic) {
                return;
            }
            Boolean oldValue = this.fItalic;
            this.fItalic = italic;
            Boolean newValue = italic;
            String property = this.fColorKey + "_italic";
            this.firePropertyChange(new PropertyChangeEvent((Object)this, property, (Object)oldValue, (Object)newValue));
        }

        public boolean isItalic() {
            return this.fItalic;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public void firePropertyChange(PropertyChangeEvent event) {
            if (SyntaxColorTab.this.fSourceViewerConfiguration != null) {
                SyntaxColorTab.this.fSourceViewerConfiguration.adaptToPreferenceChange(event);
                SyntaxColorTab.this.fPreviewViewer.invalidateTextPresentation();
            }
        }
    }
}

