/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.launcher.TracingBlock;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TracingPropertySource {
    private final IPluginModelBase fModel;
    private final Map<String, String> fTemplate;
    private final Map<String, Object> fValues = new HashMap<String, Object>();
    private final Map<String, String> fMasterOptions;
    private boolean fModified;
    private boolean fChanged;
    private final TracingBlock fBlock;

    public TracingPropertySource(IPluginModelBase model, Map<String, String> masterOptions, Map<String, String> template, TracingBlock block) {
        this.fModel = model;
        this.fMasterOptions = masterOptions;
        this.fTemplate = template;
        this.fBlock = block;
    }

    public IPluginModelBase getModel() {
        return this.fModel;
    }

    public void createContents(Composite parent, boolean enabled) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.rightMargin = 10;
        layout.leftMargin = 10;
        parent.setLayout((Layout)layout);
        boolean bordersNeeded = false;
        Iterable sortedKeys = this.fTemplate.keySet().stream().sorted()::iterator;
        for (String key : sortedKeys) {
            PropertyEditor editor;
            String shortKey = IPath.fromOSString((String)key).removeFirstSegments(1).toString();
            String value = this.fTemplate.get(key);
            String masterValue = this.fMasterOptions.get(key);
            String commentValue = this.fMasterOptions.get("#" + key);
            if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
                editor = new BooleanEditor(shortKey, shortKey, commentValue);
                if (masterValue != null) {
                    this.fValues.put(shortKey, Boolean.valueOf(masterValue));
                }
            } else {
                editor = new TextEditor(shortKey, shortKey, commentValue);
                if (masterValue != null) {
                    this.fValues.put(shortKey, masterValue);
                }
                bordersNeeded = true;
            }
            editor.create(parent, enabled);
            editor.initialize();
            if (!bordersNeeded) continue;
            this.fBlock.getToolkit().paintBordersFor(parent);
        }
    }

    public void save() {
        String pid = this.fModel.getPluginBase().getId();
        this.fValues.forEach((key, value) -> {
            IPath path = IPath.fromOSString((String)pid).append(key);
            this.fMasterOptions.put(path.toString(), value.toString());
        });
        this.fModified = false;
    }

    public boolean isModified() {
        return this.fModified;
    }

    public boolean isChanged() {
        return this.fChanged;
    }

    public void setChanged(boolean isChanged) {
        this.fChanged = isChanged;
    }

    private class BooleanEditor
    extends PropertyEditor {
        private Button checkbox;

        public BooleanEditor(String key, String label, String comment) {
            super(key, label, comment);
        }

        @Override
        public void create(Composite parent, boolean enabled) {
            this.checkbox = TracingPropertySource.this.fBlock.getToolkit().createButton(parent, this.getLabel(), 32);
            TableWrapData td = new TableWrapData();
            td.colspan = 2;
            this.checkbox.setLayoutData((Object)td);
            this.checkbox.setEnabled(enabled);
            this.createCommentDecorator((Control)this.checkbox);
        }

        @Override
        public void initialize() {
            boolean value = (Boolean)TracingPropertySource.this.fValues.get(this.getKey());
            this.checkbox.setSelection(value);
            this.checkbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.valueModified(this.checkbox.getSelection())));
            this.valueModified(value);
        }
    }

    private abstract class PropertyEditor {
        private final String key;
        private final String label;
        private final String comment;
        private static final Pattern NEW_LINE = Pattern.compile("\\r?\\n");

        public PropertyEditor(String key, String label, String comment) {
            this.key = key;
            this.label = label;
            this.comment = comment;
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public String getComment() {
            return this.comment;
        }

        abstract void create(Composite var1, boolean var2);

        abstract void initialize();

        protected void valueModified(Object value) {
            TracingPropertySource.this.fValues.put(this.getKey(), value);
            TracingPropertySource.this.fModified = true;
            TracingPropertySource.this.fChanged = true;
            TracingPropertySource.this.fBlock.getTab().scheduleUpdateJob();
        }

        protected void createCommentDecorator(Control target) {
            String commentText = this.getFormattedComment();
            if (!commentText.isEmpty()) {
                target.setToolTipText(commentText);
            }
        }

        protected String getFormattedComment() {
            String commentOrig = this.getComment();
            if (commentOrig == null || commentOrig.isEmpty()) {
                return "";
            }
            String[] lines = NEW_LINE.split(commentOrig);
            StringBuilder commentBuilder = new StringBuilder();
            boolean needsSpace = false;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                string = (string.startsWith("#") ? string.substring(1) : string).trim();
                if (string.isEmpty()) {
                    commentBuilder.append("\n\n");
                    needsSpace = false;
                } else {
                    if (needsSpace) {
                        commentBuilder.append(" ");
                    }
                    commentBuilder.append(string);
                    needsSpace = true;
                }
                ++n2;
            }
            String processed = commentBuilder.toString().trim();
            int k = processed.lastIndexOf("\n\n");
            if (k > 0) {
                return processed.substring(k + 2);
            }
            return processed;
        }
    }

    private class TextEditor
    extends PropertyEditor {
        private Text text;

        public TextEditor(String key, String label, String comment) {
            super(key, label, comment);
        }

        @Override
        public void create(Composite parent, boolean enabled) {
            Label label = TracingPropertySource.this.fBlock.getToolkit().createLabel(parent, this.getLabel());
            label.setEnabled(enabled);
            TableWrapData td = new TableWrapData();
            td.valign = 32;
            label.setLayoutData((Object)td);
            this.text = TracingPropertySource.this.fBlock.getToolkit().createText(parent, "");
            td = new TableWrapData(256);
            this.text.setLayoutData((Object)td);
            this.text.setEnabled(enabled);
            this.createCommentDecorator((Control)label);
        }

        @Override
        public void initialize() {
            String value = (String)TracingPropertySource.this.fValues.get(this.getKey());
            this.text.setText(value);
            this.text.addModifyListener(e -> this.valueModified(this.text.getText()));
            this.valueModified(value);
        }
    }
}

