/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.intro.impl.FontSelection;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.html.HTMLElement;
import org.eclipse.ui.internal.intro.impl.html.IntroHTMLGenerator;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.model.History;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.internal.intro.impl.model.loader.IntroContentParser;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartLocationListener;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IIntroXHTMLContentProvider;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BrowserIntroPartImplementation
extends AbstractIntroPartImplementation
implements IPropertyListener,
IIntroContentProviderSite {
    private static final int SCALE_INCREMENT = 20;
    protected Browser browser = null;
    private IntroHTMLGenerator htmlGenerator = null;
    private String savedContent = null;
    private final Action openBrowserAction = new Action(){
        {
            this.setToolTipText(Messages.IntroPart_openExternal_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("topic.png"));
        }

        public void run() {
            try {
                File tempFile = File.createTempFile("intro", ".html");
                tempFile.deleteOnExit();
                Throwable throwable = null;
                Object var3_6 = null;
                try (BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));){
                    out.write(BrowserIntroPartImplementation.this.savedContent);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser browser = support.getExternalBrowser();
                browser.openURL(tempFile.toURI().toURL());
            }
            catch (IOException iOException) {
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    };
    protected BrowserIntroPartLocationListener urlListener = new BrowserIntroPartLocationListener(this);
    private boolean isFinishedLoading;
    private final boolean resizeActionsAdded = false;

    private void restartIntro() {
        IIntroManager manager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart part = manager.getIntro();
        if (part != null && part instanceof CustomizableIntroPart) {
            IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
            String currentPageId = modelRoot.getCurrentPageId();
            IWorkbenchWindow window = part.getIntroSite().getWorkbenchWindow();
            boolean standby = manager.isIntroStandby(part);
            PlatformUI.getWorkbench().getIntroManager().closeIntro(part);
            IntroPlugin.getDefault().resetVolatileImageRegistry();
            part = PlatformUI.getWorkbench().getIntroManager().showIntro(window, standby);
            if (part != null && !standby) {
                StringBuilder url = new StringBuilder();
                url.append("http://org.eclipse.ui.intro/showPage?id=");
                url.append(currentPageId);
                IIntroURL introURL = IntroURLFactory.createIntroURL(url.toString());
                if (introURL != null) {
                    introURL.execute();
                }
            }
        }
    }

    @Override
    protected void updateNavigationActionsState() {
        if (this.getModel().isDynamic()) {
            this.forwardAction.setEnabled(this.history.canNavigateForward());
            this.backAction.setEnabled(this.history.canNavigateBackward());
            return;
        }
        this.forwardAction.setEnabled(this.browser.isForwardEnabled());
        this.backAction.setEnabled(this.browser.isBackEnabled());
    }

    @Override
    public void createPartControl(Composite parent) {
        long start = 0L;
        if (Log.logPerformance) {
            start = System.currentTimeMillis();
        }
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener((LocationListener)this.urlListener);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                BrowserIntroPartImplementation.this.urlListener.flagEndOfNavigation();
                BrowserIntroPartImplementation.this.urlListener.flagEndOfFrameNavigation();
                BrowserIntroPartImplementation.this.urlListener.flagRemovedTempUrl();
                if (!BrowserIntroPartImplementation.this.getModel().isDynamic()) {
                    BrowserIntroPartImplementation.this.updateNavigationActionsState();
                }
            }
        });
        this.browser.addListener(35, event -> {
            event.doit = IntroPlugin.getDefault().isDebugging();
        });
        if (Log.logPerformance) {
            Util.logPerformanceTime("creating a new Browser() took:", start);
        }
        this.addToolBarActions();
        if (!this.getModel().hasValidConfig()) {
            this.browser.setText(Messages.Browser_invalidConfig);
            return;
        }
        if (this.getModel().isDynamic()) {
            this.handleDynamicIntro();
        } else {
            this.handleStaticIntro();
        }
    }

    private void handleDynamicIntro() {
        AbstractIntroPage homePage = this.getModel().getHomePage();
        String cachedPage = this.getCachedCurrentPage();
        if (cachedPage != null) {
            if (History.isURL(cachedPage)) {
                boolean success = this.browser.setUrl(cachedPage);
                if (!success) {
                    Log.error("Unable to set the following ULR in browser: " + cachedPage, null);
                    return;
                }
                this.history.updateHistory(cachedPage);
            } else {
                this.getModel().setCurrentPageId(cachedPage, false);
                this.history.updateHistory(this.getModel().getCurrentPage());
            }
        } else {
            this.history.updateHistory(homePage);
        }
        this.getModel().addPropertyListener(this);
    }

    private boolean generateContentForPage(AbstractIntroPage page) {
        Object content = null;
        if (!page.isDynamic()) {
            this.browser.setUrl(page.getUrl());
            return true;
        }
        if (page.isXHTMLPage()) {
            content = this.generateXHTMLPage(page, this);
        } else {
            HTMLElement html = this.getHTMLGenerator().generateHTMLforPage(page, this);
            if (html != null) {
                IntroModelRoot root = this.getModel();
                if (root != null) {
                    Map<String, String> props;
                    IntroTheme theme = root.getTheme();
                    Map<String, String> map = props = theme != null ? theme.getProperties() : null;
                    if (props != null) {
                        String value = props.get("standardSupport");
                        String doctype = null;
                        if ("html5".equalsIgnoreCase(value)) {
                            doctype = "<!DOCTYPE html>\n";
                        } else if ("strict".equalsIgnoreCase(value)) {
                            doctype = this.generateDoctype(true);
                        } else if ("loose".equalsIgnoreCase(value)) {
                            doctype = this.generateDoctype(false);
                        }
                        if (doctype != null) {
                            content = doctype + html.toString();
                        }
                    }
                }
                if (content == null) {
                    content = html.toString();
                }
            }
        }
        if (content == null) {
            Log.error("Error generating HTML content for page", null);
            return false;
        }
        boolean success = false;
        if (this.browser != null) {
            long start = 0L;
            if (Log.logPerformance) {
                start = System.currentTimeMillis();
            }
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    if (event.top) {
                        BrowserIntroPartImplementation.this.isFinishedLoading = true;
                    }
                }
            });
            success = this.browser.setText((String)content);
            if (Log.logPerformance) {
                Util.logPerformanceTime("setText() on the browser took:", start);
            }
            if (!success) {
                Log.error("Unable to set HTML on the browser", null);
            }
        }
        if (IntroPlugin.getDefault().isDebugging()) {
            String printHtml = Platform.getDebugOption((String)"org.eclipse.ui.intro/trace/printHTML");
            if (printHtml != null && printHtml.equalsIgnoreCase("true")) {
                System.out.println((String)content);
            }
            if (IntroPlugin.DEBUG_TOOLBAR) {
                this.savedContent = content;
            }
        }
        return success;
    }

    public String generateXHTMLPage(AbstractIntroPage page, IIntroContentProviderSite site) {
        Document dom = page.getResolvedDocument();
        NodeList nodes = dom.getElementsByTagNameNS("*", "contentProvider");
        Node[] contentProviderElements = ModelUtil.getArray(nodes);
        this.resolveDynamicContent(page, site);
        String content = IntroContentParser.convertToString(dom);
        this.reinjectDynamicContent(dom, contentProviderElements);
        return content;
    }

    private String generateDoctype(boolean strict) {
        StringWriter swriter = new StringWriter();
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = new PrintWriter(swriter);){
            if (strict) {
                writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
                writer.println("\t\t\t\"http://www.w3.org/TR/html4/strict.dtd\">");
            } else {
                writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
                writer.println("\t\t\t\"http://www.w3.org/TR/html4/loose.dtd\">");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return swriter.toString();
    }

    private Document resolveDynamicContent(AbstractIntroPage page, IIntroContentProviderSite site) {
        Document dom = page.getResolvedDocument();
        NodeList contentProviders = dom.getElementsByTagNameNS("*", "contentProvider");
        Node[] nodes = ModelUtil.getArray(contentProviders);
        int i = 0;
        while (i < nodes.length) {
            Element contentProviderElement = (Element)nodes[i];
            IntroContentProvider provider = new IntroContentProvider(contentProviderElement, page.getBundle());
            provider.setParent(page);
            IIntroXHTMLContentProvider providerClass = (IIntroXHTMLContentProvider)ContentProviderManager.getInst().getContentProvider(provider);
            if (providerClass == null) {
                providerClass = (IIntroXHTMLContentProvider)ContentProviderManager.getInst().createContentProvider(provider, site);
            }
            if (providerClass != null) {
                Properties att = new Properties();
                att.setProperty("id", provider.getId());
                Element contentDiv = ModelUtil.createElement(dom, ModelUtil.TAG_DIV, att);
                providerClass.createContent(provider.getId(), contentDiv);
                contentProviderElement.getParentNode().replaceChild(contentDiv, contentProviderElement);
            }
            ++i;
        }
        return dom;
    }

    private void reinjectDynamicContent(Document dom, Node[] contentProviderElements) {
        int i = 0;
        while (i < contentProviderElements.length) {
            Element contentProviderElement = (Element)contentProviderElements[i];
            Element contentProviderDiv = ModelUtil.getElementById(dom, contentProviderElement.getAttribute("id"), ModelUtil.TAG_DIV);
            contentProviderDiv.getParentNode().replaceChild(contentProviderElement, contentProviderDiv);
            ++i;
        }
    }

    private IntroHTMLGenerator getHTMLGenerator() {
        if (this.htmlGenerator == null) {
            this.htmlGenerator = new IntroHTMLGenerator();
        }
        return this.htmlGenerator;
    }

    @Override
    protected void addToolBarActions() {
        boolean createZoomButtons;
        IActionBars actionBars = this.getIntroPart().getIntroSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        if (IntroPlugin.DEBUG_TOOLBAR) {
            toolBarManager.add((IAction)this.viewIntroModelAction);
            toolBarManager.add((IAction)this.openBrowserAction);
        }
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)this.homeAction);
        toolBarManager.add((IAction)this.backAction);
        toolBarManager.add((IAction)this.forwardAction);
        toolBarManager.update(true);
        IntroTheme theme = this.getModel().getTheme();
        boolean bl = createZoomButtons = theme != null && theme.isScalable() && "relative".equals(FontSelection.getFontStyle());
        if (createZoomButtons) {
            toolBarManager.add((IAction)new ReduceAction());
            toolBarManager.add((IAction)new MagnifyAction());
        }
        actionBars.updateActionBars();
        this.updateNavigationActionsState();
    }

    public void dynamicStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded) {
            return;
        }
        if (this.history.currentLocationIsUrl()) {
            return;
        }
        IntroModelRoot model = this.getModel();
        AbstractIntroPage homePage = model.getHomePage();
        AbstractIntroPage standbyPage = model.getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.generateContentForPage(standbyPage);
        } else {
            AbstractIntroPage currentPage = model.getCurrentPage();
            if (currentPage == null || standbyPage.getId().equals(currentPage.getId())) {
                model.setCurrentPageId(model.getHomePage().getId());
            }
            this.generateContentForPage(currentPage);
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            String pageId = this.getModel().getCurrentPageId();
            if (pageId == null || pageId.isEmpty()) {
                return;
            }
            this.updateContent();
        }
    }

    @Override
    public void setFocus() {
        this.browser.setFocus();
    }

    @Override
    public void dispose() {
        this.browser.dispose();
    }

    protected void updateContent() {
        if (!this.getBrowser().isDisposed()) {
            this.generateContentForPage(this.getModel().getCurrentPage());
        }
    }

    @Override
    public void reflow(IIntroContentProvider provider, boolean incremental) {
        this.updateContent();
    }

    @Override
    protected void saveCurrentPage(IMemento memento) {
        if (memento == null) {
            return;
        }
        if (this.browser != null && this.browser.getUrl() != null && this.browser.getUrl().length() > 0 && !this.browser.getUrl().equals("about:blank") && !this.browser.getUrl().equals("file:///")) {
            String currentURL = this.browser.getUrl();
            if (currentURL != null) {
                memento.putString("currentPage", currentURL);
            }
        } else {
            super.saveCurrentPage(memento);
        }
    }

    @Override
    public boolean navigateBackward() {
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.history.canNavigateBackward()) {
                this.history.navigateHistoryBackward();
                this.urlListener.flagStartOfNavigation();
                if (this.history.currentLocationIsUrl()) {
                    success = this.browser.setUrl(this.history.getCurrentLocationAsUrl());
                } else {
                    AbstractIntroPage page = this.history.getCurrentLocationAsPage();
                    this.getModel().setCurrentPageId(page.getId(), false);
                    success = this.generateContentForPage(page);
                }
            } else {
                success = false;
            }
            this.updateNavigationActionsState();
        } else {
            success = this.browser.back();
        }
        return success;
    }

    @Override
    public boolean navigateForward() {
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.history.canNavigateForward()) {
                this.history.navigateHistoryForward();
                this.urlListener.flagStartOfNavigation();
                if (this.history.currentLocationIsUrl()) {
                    success = this.browser.setUrl(this.history.getCurrentLocationAsUrl());
                } else {
                    AbstractIntroPage page = this.history.getCurrentLocationAsPage();
                    this.getModel().setCurrentPageId(page.getId(), false);
                    success = this.generateContentForPage(page);
                }
            } else {
                success = false;
            }
            this.updateNavigationActionsState();
        } else {
            success = this.browser.forward();
        }
        return success;
    }

    @Override
    public boolean navigateHome() {
        AbstractIntroPage rootPage = this.getModel().getHomePage();
        boolean success = false;
        if (this.getModel().isDynamic()) {
            if (this.history.currentLocationIsUrl()) {
                this.generateContentForPage(rootPage);
            }
            success = this.getModel().setCurrentPageId(rootPage.getId());
            this.updateHistory(rootPage);
        } else {
            String location = rootPage.getUrl();
            success = this.browser.setUrl(location);
            this.updateHistory(location);
        }
        return success;
    }

    @Override
    protected void handleRegistryChanged(IRegistryChangeEvent event) {
        if (this.getModel().isDynamic()) {
            this.htmlGenerator = null;
            this.getModel().addPropertyListener(this);
            this.getModel().firePropertyChange(1);
        }
    }

    @Override
    protected void doStandbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (isStandbyPartNeeded || standby) {
            this.homeAction.setEnabled(false);
            this.forwardAction.setEnabled(false);
            this.backAction.setEnabled(false);
        } else {
            this.homeAction.setEnabled(true);
            this.updateNavigationActionsState();
        }
        if (this.getModel().isDynamic()) {
            this.dynamicStandbyStateChanged(standby, isStandbyPartNeeded);
        } else {
            this.staticStandbyStateChanged(standby);
        }
    }

    private void handleStaticIntro() {
        String url = this.getCachedCurrentPage();
        if (!History.isURL(url)) {
            url = this.getModel().getHomePage().getUrl();
        }
        if (url == null) {
            Log.error("Url is null; no content to display in browser", null);
            return;
        }
        boolean success = this.browser.setUrl(url);
        if (!success) {
            Log.error("Unable to set the following ULR in browser: " + url, null);
            return;
        }
    }

    public void staticStandbyStateChanged(boolean standby) {
        AbstractIntroPage homePage = this.getModel().getHomePage();
        AbstractIntroPage standbyPage = this.getModel().getStandbyPage();
        if (standbyPage == null) {
            standbyPage = homePage;
        }
        if (standby) {
            this.browser.setUrl(standbyPage.getUrl());
        } else {
            this.browser.setUrl(homePage.getUrl());
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public boolean isFinishedLoading() {
        return this.isFinishedLoading;
    }

    private final class MagnifyAction
    extends Action {
        private MagnifyAction() {
            this.setToolTipText(Messages.Browser_magnify_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/magnify_font.png"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/magnify_font.png"));
            int scalePercent = FontSelection.getScalePercentage();
            this.setEnabled(scalePercent < 100);
        }

        public void run() {
            int scalePercent = FontSelection.getScalePercentage();
            FontSelection.setScalePercentage(scalePercent + 20);
            BrowserIntroPartImplementation.this.restartIntro();
        }
    }

    private final class ReduceAction
    extends Action {
        private ReduceAction() {
            this.setToolTipText(Messages.Browser_reduce_tooltip);
            this.setImageDescriptor(ImageUtil.createImageDescriptor("full/elcl16/reduce_font.png"));
            this.setDisabledImageDescriptor(ImageUtil.createImageDescriptor("full/dlcl16/reduce_font.png"));
            int scalePercent = FontSelection.getScalePercentage();
            this.setEnabled(scalePercent > -40);
        }

        public void run() {
            int scalePercent = FontSelection.getScalePercentage();
            FontSelection.setScalePercentage(scalePercent - 20);
            BrowserIntroPartImplementation.this.restartIntro();
        }
    }
}

