/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.UpdateSinceTagOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class SinceTagResolution
extends WorkbenchMarkerResolution {
    int kind;
    String newVersionValue;
    IMarker marker;
    IMarker[] otherMarkers;

    public SinceTagResolution(IMarker marker) {
        this.marker = marker;
        this.kind = ApiProblemFactory.getProblemKind((int)marker.getAttribute("problemid", 0));
        this.newVersionValue = marker.getAttribute("version", null);
    }

    public String getDescription() {
        if (1 == this.kind) {
            return NLS.bind((String)MarkerMessages.SinceTagResolution_change_since_tag, (Object)this.newVersionValue);
        }
        if (2 == this.kind) {
            return NLS.bind((String)MarkerMessages.SinceTagResolution_change_since_tag, (Object)this.newVersionValue);
        }
        return NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag, (Object)this.newVersionValue);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
    }

    public String getLabel() {
        if (1 == this.kind) {
            return NLS.bind((String)MarkerMessages.SinceTagResolution_change_since_tag, (Object)this.newVersionValue);
        }
        if (2 == this.kind) {
            return NLS.bind((String)MarkerMessages.SinceTagResolution_change_since_tag, (Object)this.newVersionValue);
        }
        return NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag, (Object)this.newVersionValue);
    }

    public void run(IMarker marker) {
        String title = null;
        title = 1 == this.kind ? NLS.bind((String)MarkerMessages.SinceTagResolution_change_since_tag, (Object)this.newVersionValue) : (2 == this.kind ? NLS.bind((String)MarkerMessages.SinceTagResolution_change_since_tag, (Object)this.newVersionValue) : NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag, (Object)this.newVersionValue));
        UIJob job = UIJob.create((String)title, monitor -> {
            this.kind = ApiProblemFactory.getProblemKind((int)marker.getAttribute("problemid", 0));
            this.newVersionValue = marker.getAttribute("version", null);
            UpdateSinceTagOperation updateSinceTagOperation = new UpdateSinceTagOperation(marker, this.otherMarkers, this.kind, marker.getAttribute("version", null));
            updateSinceTagOperation.run(monitor);
        });
        job.setSystem(true);
        job.schedule();
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            int kind2;
            IMarker iMarker = iMarkerArray[n2];
            if (!iMarker.equals((Object)this.marker) && (kind2 = ApiProblemFactory.getProblemKind((int)iMarker.getAttribute("problemid", 0))) == this.kind) {
                mset.add(iMarker);
            }
            ++n2;
        }
        int size = mset.size();
        this.otherMarkers = mset.toArray(new IMarker[size]);
        return this.otherMarkers;
    }
}

