/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.ecl.filesystem.EclFile;

public class Util {
    public static Writer getWriter(final EclFile file, final boolean append, final String encode) {
        StringWriter writer = new StringWriter(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    String encoding = encode != null && encode.length() != 0 ? encode : StandardCharsets.UTF_8.name();
                    ByteArrayInputStream is = new ByteArrayInputStream(this.toString().getBytes(encoding));
                    if (append) {
                        file.append(is);
                    } else {
                        file.write(is);
                    }
                }
                catch (CoreException e) {
                    throw new IOException("Failed to write " + file.toURI().toString(), e);
                }
            }
        };
        return writer;
    }

    public static Writer getWriter(EclFile file, boolean append) {
        return Util.getWriter(file, append, StandardCharsets.UTF_8.name());
    }
}

