/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ds.ui.parts.IFormEntryListener;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.events.HyperlinkEvent;

public class FormEntryAdapter
implements IFormEntryListener {
    private final IContextPart contextPart;
    protected IActionBars actionBars;

    public FormEntryAdapter(IContextPart contextPart) {
        this(contextPart, null);
    }

    public FormEntryAdapter(IContextPart contextPart, IActionBars actionBars) {
        this.contextPart = contextPart;
        this.actionBars = actionBars;
    }

    @Override
    public void focusGained(FormEntry entry) {
        TextSelection selection = new TextSelection(1, 1);
        this.contextPart.getPage().getPDEEditor().getContributor().updateSelectableActions((ISelection)selection);
    }

    @Override
    public void textDirty(FormEntry entry) {
        this.contextPart.fireSaveNeeded();
    }

    @Override
    public void textValueChanged(FormEntry entry) {
    }

    @Override
    public void browseButtonSelected(FormEntry entry) {
    }

    public void linkEntered(HyperlinkEvent e) {
        if (this.actionBars == null) {
            return;
        }
        IStatusLineManager mng = this.actionBars.getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        if (this.actionBars == null) {
            return;
        }
        IStatusLineManager mng = this.actionBars.getStatusLineManager();
        mng.setMessage(null);
    }

    public void linkActivated(HyperlinkEvent e) {
    }

    @Override
    public void selectionChanged(FormEntry entry) {
        TextSelection selection = new TextSelection(1, 1);
        this.contextPart.getPage().getPDEEditor().getContributor().updateSelectableActions((ISelection)selection);
    }
}

