/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.text.CompletionTimeoutProgressMonitor;
import org.eclipse.jdt.internal.ui.text.correction.NameMatcher;
import org.eclipse.jdt.internal.ui.text.correction.SimilarElement;

public class SimilarElementsRequestor
extends CompletionRequestor {
    private static final String[] PRIM_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private int fKind;
    private String fName;
    private HashSet<SimilarElement> fResult;
    private boolean fExcludeTestCode;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTestSource(ICompilationUnit cu) {
        try {
            IJavaProject javaProject = cu.getJavaProject();
            if (javaProject == null) {
                return false;
            }
            IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(true);
            IPath resourcePath = cu.getResource().getFullPath();
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (e.getEntryKind() == 3 && e.isTest() && e.getPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public static SimilarElement[] findSimilarElement(ICompilationUnit cu, Name name, int kind) throws JavaModelException {
        int pos = name.getStartPosition();
        int nArguments = -1;
        String identifier = ASTNodes.getSimpleNameIdentifier(name);
        String returnType = null;
        ICompilationUnit preparedCU = null;
        try {
            pos = name.isQualifiedName() ? ((QualifiedName)name).getName().getStartPosition() : name.getStartPosition() + 1;
            Javadoc javadoc = (Javadoc)ASTNodes.getParent((ASTNode)name, 29);
            if (javadoc != null) {
                cu = preparedCU = SimilarElementsRequestor.createPreparedCU(cu, javadoc, name.getStartPosition());
            }
            SimilarElementsRequestor requestor = new SimilarElementsRequestor(identifier, kind, nArguments, returnType, !SimilarElementsRequestor.isTestSource(cu));
            requestor.setIgnored(1, true);
            requestor.setIgnored(27, true);
            requestor.setIgnored(3, true);
            requestor.setIgnored(4, true);
            requestor.setIgnored(7, true);
            requestor.setIgnored(8, true);
            requestor.setIgnored(29, true);
            requestor.setIgnored(28, true);
            requestor.setIgnored(10, true);
            requestor.setIgnored(6, true);
            requestor.setIgnored(26, true);
            requestor.setIgnored(24, true);
            requestor.setIgnored(2, true);
            requestor.setIgnored(25, true);
            requestor.setIgnored(5, true);
            requestor.setIgnored(10, true);
            requestor.setIgnored(10, true);
            requestor.setIgnored(11, true);
            requestor.setIgnored(12, true);
            SimilarElement[] similarElementArray = requestor.process(cu, pos);
            return similarElementArray;
        }
        finally {
            if (preparedCU != null) {
                preparedCU.discardWorkingCopy();
            }
        }
    }

    private static ICompilationUnit createPreparedCU(ICompilationUnit cu, Javadoc comment, int wordStart) throws JavaModelException {
        int startpos = comment.getStartPosition();
        boolean isTopLevel = comment.getParent().getParent() instanceof CompilationUnit;
        char[] content = (char[])cu.getBuffer().getCharacters().clone();
        if (isTopLevel && wordStart + 6 < content.length) {
            content[startpos++] = 105;
            content[startpos++] = 109;
            content[startpos++] = 112;
            content[startpos++] = 111;
            content[startpos++] = 114;
            content[startpos++] = 116;
        }
        if (wordStart < content.length) {
            int i = startpos;
            while (i < wordStart) {
                content[i] = 32;
                ++i;
            }
        }
        ICompilationUnit newCU = cu.getWorkingCopy(null);
        newCU.getBuffer().setContents(content);
        return newCU;
    }

    private SimilarElementsRequestor(String name, int kind, int nArguments, String preferredType, boolean excludeTestCode) {
        this.fName = name;
        this.fKind = kind;
        this.fExcludeTestCode = excludeTestCode;
        this.fResult = new HashSet();
    }

    private void addResult(SimilarElement elem) {
        this.fResult.add(elem);
    }

    private SimilarElement[] process(ICompilationUnit cu, int pos) throws JavaModelException {
        try {
            cu.codeComplete(pos, (CompletionRequestor)this, (IProgressMonitor)new CompletionTimeoutProgressMonitor());
            this.processKeywords();
            SimilarElement[] similarElementArray = this.fResult.toArray(new SimilarElement[this.fResult.size()]);
            return similarElementArray;
        }
        finally {
            this.fResult.clear();
        }
    }

    private boolean isKind(int kind) {
        return (this.fKind & kind) != 0;
    }

    private void processKeywords() {
        String voidType;
        if (this.isKind(64)) {
            String[] stringArray = PRIM_TYPES;
            int n = PRIM_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (NameMatcher.isSimilarName(this.fName, t)) {
                    this.addResult(new SimilarElement(64, t, 50));
                }
                ++n2;
            }
        }
        if (this.isKind(128) && NameMatcher.isSimilarName(this.fName, voidType = "void")) {
            this.addResult(new SimilarElement(64, voidType, 50));
        }
    }

    private static final int getKind(int flags, char[] typeNameSig) {
        if (Signature.getTypeSignatureKind((char[])typeNameSig) == 3) {
            return 32;
        }
        if (Flags.isAnnotation((int)flags)) {
            return 8;
        }
        if (Flags.isInterface((int)flags)) {
            return 4;
        }
        if (Flags.isEnum((int)flags)) {
            return 16;
        }
        return 2;
    }

    private void addType(char[] typeNameSig, int flags, int relevance) {
        int kind = SimilarElementsRequestor.getKind(flags, typeNameSig);
        if (!this.isKind(kind)) {
            return;
        }
        String fullName = new String(Signature.toCharArray((char[])Signature.getTypeErasure((char[])typeNameSig)));
        if (TypeFilter.isFiltered(fullName)) {
            return;
        }
        if (NameMatcher.isSimilarName(this.fName, Signature.getSimpleName((String)fullName))) {
            this.addResult(new SimilarElement(kind, fullName, relevance));
        }
    }

    public void accept(CompletionProposal proposal) {
        if (proposal.getKind() == 9) {
            this.addType(proposal.getSignature(), proposal.getFlags(), proposal.getRelevance());
        }
    }

    public boolean isTestCodeExcluded() {
        return this.fExcludeTestCode;
    }
}

