/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.BooleanValueRatherThanComparisonFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class BooleanValueRatherThanComparisonCleanUpCore
extends AbstractCleanUp {
    public BooleanValueRatherThanComparisonCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public BooleanValueRatherThanComparisonCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.boolean_value_rather_than_comparison");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.boolean_value_rather_than_comparison")) {
            return null;
        }
        return BooleanValueRatherThanComparisonFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.boolean_value_rather_than_comparison")) {
            return new String[]{MultiFixMessages.BooleanValueRatherThanComparisonCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.boolean_value_rather_than_comparison")) {
            return "boolean booleanValue = isValid;\nboolean booleanValue2 = !isValid;\nboolean booleanValue3 = i <= 0;\nboolean booleanValue4 = !booleanObject;\n";
        }
        return "boolean booleanValue = isValid == true;\nboolean booleanValue2 = isValid == false;\nboolean booleanValue3 = Boolean.FALSE.equals(i > 0);\nboolean booleanValue4 = booleanObject.equals(Boolean.FALSE);\n";
    }
}

