/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class MoveStaticMemberAnalyzer
extends ASTVisitor {
    protected RefactoringStatus fStatus = new RefactoringStatus();
    protected ITypeBinding fSource;
    protected ITypeBinding fTarget;
    protected CompilationUnitRewrite fCuRewrite;
    protected IBinding[] fMembers;
    protected boolean fNeedsImport;
    protected Set<SimpleName> fProcessed;
    protected static final String REFERENCE_UPDATE = RefactoringCoreMessages.MoveMembersRefactoring_referenceUpdate;

    public MoveStaticMemberAnalyzer(CompilationUnitRewrite cuRewrite, IBinding[] members, ITypeBinding source, ITypeBinding target) {
        super(true);
        this.fCuRewrite = cuRewrite;
        this.fMembers = members;
        this.fSource = source;
        this.fTarget = target;
        this.fProcessed = new HashSet<SimpleName>();
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    protected boolean isProcessed(ASTNode node) {
        return this.fProcessed.contains(node);
    }

    protected void rewrite(SimpleName node, ITypeBinding type) {
        AST ast = node.getAST();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)node, this.fCuRewrite.getImportRewrite());
        Type result = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
        this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
        Name dummy = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)result));
        QualifiedName name = ast.newQualifiedName(dummy, ast.newSimpleName(node.getIdentifier()));
        this.fCuRewrite.getASTRewrite().replace((ASTNode)node, (ASTNode)name, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)node);
        this.fProcessed.add(node);
        this.fNeedsImport = true;
    }

    protected void rewrite(QualifiedName node, ITypeBinding type) {
        this.rewriteName(node.getQualifier(), type);
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(FieldAccess node, ITypeBinding type) {
        Expression exp = node.getExpression();
        if (exp == null) {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)node, this.fCuRewrite.getImportRewrite());
            Type result = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
            this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
            exp = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)result));
            this.fCuRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)FieldAccess.EXPRESSION_PROPERTY, (Object)exp, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else if (exp instanceof Name) {
            this.rewriteName((Name)exp, type);
        } else {
            this.rewriteExpression((ASTNode)node, exp, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MethodInvocation node, ITypeBinding type) {
        Expression exp = node.getExpression();
        if (exp == null) {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)node, this.fCuRewrite.getImportRewrite());
            Type result = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
            this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
            exp = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)result));
            this.fCuRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)exp, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else if (exp instanceof Name) {
            this.rewriteName((Name)exp, type);
        } else {
            this.rewriteExpression((ASTNode)node, exp, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MemberRef node, ITypeBinding type) {
        Name qualifier = node.getQualifier();
        if (qualifier == null) {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)node, this.fCuRewrite.getImportRewrite());
            Type result = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
            this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
            qualifier = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)result));
            this.fCuRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)MemberRef.QUALIFIER_PROPERTY, (Object)qualifier, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else {
            this.rewriteName(qualifier, type);
        }
        this.fProcessed.add(node.getName());
    }

    protected void rewrite(MethodRef node, ITypeBinding type) {
        Name qualifier = node.getQualifier();
        if (qualifier == null) {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)node, this.fCuRewrite.getImportRewrite());
            Type result = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
            this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
            qualifier = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)result));
            this.fCuRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)MethodRef.QUALIFIER_PROPERTY, (Object)qualifier, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fNeedsImport = true;
        } else {
            this.rewriteName(qualifier, type);
        }
        this.fProcessed.add(node.getName());
    }

    private void rewriteName(Name name, ITypeBinding type) {
        SimpleName left;
        AST creator = name.getAST();
        boolean fullyQualified = false;
        if (name instanceof QualifiedName && (left = ASTNodes.getLeftMostSimpleName(name)).resolveBinding() instanceof IPackageBinding) {
            fullyQualified = true;
        }
        if (fullyQualified) {
            this.fCuRewrite.getASTRewrite().replace((ASTNode)name, (ASTNode)ASTNodeFactory.newName(creator, type.getQualifiedName()), this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
        } else {
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)name, this.fCuRewrite.getImportRewrite());
            Type result = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
            this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
            Name n = ASTNodeFactory.newName(this.fCuRewrite.getAST(), ASTFlattener.asString((ASTNode)result));
            this.fCuRewrite.getASTRewrite().replace((ASTNode)name, (ASTNode)n, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
            this.fNeedsImport = true;
        }
    }

    private void rewriteExpression(ASTNode node, Expression exp, ITypeBinding type) {
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)exp, this.fCuRewrite.getImportRewrite());
        Type typeNode = this.fCuRewrite.getImportRewrite().addImport(type, this.fCuRewrite.getAST(), (ImportRewrite.ImportRewriteContext)context);
        this.fCuRewrite.getASTRewrite().replace((ASTNode)exp, (ASTNode)typeNode, this.fCuRewrite.createGroupDescription(REFERENCE_UPDATE));
        this.fCuRewrite.getImportRemover().registerAddedImport(type.getQualifiedName());
        this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)exp);
        this.fNeedsImport = true;
        this.nonStaticAccess(node);
    }

    protected void nonStaticAccess(ASTNode node) {
        this.fStatus.addWarning(RefactoringCoreMessages.MoveStaticMemberAnalyzer_nonStatic, JavaStatusContext.create((ITypeRoot)this.fCuRewrite.getCu(), node));
    }

    protected boolean isStaticAccess(Expression exp, ITypeBinding type) {
        if (!(exp instanceof Name)) {
            return false;
        }
        return Bindings.equals((IBinding)type, ((Name)exp).resolveBinding());
    }

    protected boolean isMovedMember(IBinding binding) {
        if (binding == null) {
            return false;
        }
        IBinding[] iBindingArray = this.fMembers;
        int n = this.fMembers.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding member = iBindingArray[n2];
            if (Bindings.equalDeclarations(member, binding)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

