/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.helper.LambdaQueries;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class ChangeLambdaBodyToExpressionFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ChangeLambdaBodyToExpressionFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    public static ChangeLambdaBodyToExpressionFixCore createChangeLambdaBodyToBlockFix(CompilationUnit compilationUnit, ASTNode node) {
        LambdaExpression lambda;
        if (node instanceof LambdaExpression) {
            lambda = (LambdaExpression)node;
        } else if (node.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            lambda = (LambdaExpression)node.getParent();
        } else {
            return null;
        }
        if (!(lambda.getBody() instanceof Block)) {
            return null;
        }
        Block lambdaBody = (Block)lambda.getBody();
        Expression exprBody = LambdaQueries.getSingleExpressionFromLambdaBody(lambdaBody);
        if (exprBody == null) {
            return null;
        }
        String label = CorrectionMessages.QuickAssistProcessor_change_lambda_body_to_expression;
        return new ChangeLambdaBodyToExpressionFixCore(label, compilationUnit, new ChangeLambdaBodyToExpressionProposalOperation(lambda, exprBody));
    }

    private static class ChangeLambdaBodyToExpressionProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private LambdaExpression lambda;
        private Expression exprBody;

        public ChangeLambdaBodyToExpressionProposalOperation(LambdaExpression lambda, Expression exprBody) {
            this.lambda = lambda;
            this.exprBody = exprBody;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            Expression movedBody = (Expression)rewrite.createMoveTarget((ASTNode)this.exprBody);
            rewrite.set((ASTNode)this.lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)movedBody, null);
        }
    }
}

