/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationMessages;
import org.eclipse.jdt.internal.core.manipulation.MembersOrderPreferenceCacheCommon;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class JavaManipulationPlugin
extends Plugin
implements DebugOptionsListener {
    public static final boolean CODEASSIST_SUBSTRING_MATCH_ENABLED = Boolean.parseBoolean(System.getProperty("jdt.codeCompleteSubstringMatch", "true"));
    public static final String CODEASSIST_FAVORITE_STATIC_MEMBERS = "content_assist_favorite_static_members";
    public static boolean DEBUG_AST_PROVIDER;
    public static boolean DEBUG_TYPE_CONSTRAINTS;
    private static JavaManipulationPlugin fgDefault;
    private MembersOrderPreferenceCacheCommon fMembersOrderPreferenceCacheCommon;
    private volatile TypeFilter fTypeFilter;
    private BundleContext fBundleContext;

    public JavaManipulationPlugin() {
        fgDefault = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        fgDefault = null;
        if (this.fTypeFilter != null) {
            this.fTypeFilter.dispose();
            this.fTypeFilter = null;
        }
    }

    public static JavaManipulationPlugin getDefault() {
        return fgDefault;
    }

    public MembersOrderPreferenceCacheCommon getMembersOrderPreferenceCacheCommon() {
        if (this.fMembersOrderPreferenceCacheCommon == null) {
            this.fMembersOrderPreferenceCacheCommon = new MembersOrderPreferenceCacheCommon();
        }
        return this.fMembersOrderPreferenceCacheCommon;
    }

    public void setMembersOrderPreferenceCacheCommon(MembersOrderPreferenceCacheCommon mpcc) {
        this.fMembersOrderPreferenceCacheCommon = mpcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeFilter getTypeFilter() {
        TypeFilter result = this.fTypeFilter;
        if (result != null) {
            return result;
        }
        JavaManipulationPlugin javaManipulationPlugin = this;
        synchronized (javaManipulationPlugin) {
            if (this.fTypeFilter == null) {
                this.fTypeFilter = new TypeFilter();
            }
            return this.fTypeFilter;
        }
    }

    public static void log(Throwable e) {
        ILog.of(JavaManipulationPlugin.class).log((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", 10001, JavaManipulationMessages.JavaManipulationMessages_internalError, e));
    }

    public static void log(IStatus status) {
        ILog.of(JavaManipulationPlugin.class).log(status);
    }

    public static void logErrorMessage(String message) {
        JavaManipulationPlugin.log((IStatus)new Status(4, JavaManipulationPlugin.getPluginId(), 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            JavaManipulationPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(JavaManipulationPlugin.getPluginId(), 10001, message, null);
        multi.add(status);
        JavaManipulationPlugin.log((IStatus)multi);
    }

    public static String getPluginId() {
        return "org.eclipse.jdt.core.manipulation";
    }

    public Bundle[] getBundles(String bundleName, String version) {
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        ServiceReference serviceRef = this.fBundleContext.getServiceReference(PackageAdmin.class);
        PackageAdmin admin = (PackageAdmin)this.fBundleContext.getService(serviceRef);
        bundles = admin.getBundles(bundleName, version);
        if (bundles != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public void optionsChanged(DebugOptions options) {
        DEBUG_AST_PROVIDER = options.getBooleanOption("org.eclipse.jdt.core.manipulation/debug/ASTProvider", false);
        DEBUG_TYPE_CONSTRAINTS = options.getBooleanOption("org.eclipse.jdt.core.manipulation/debug/TypeConstraints", false);
    }
}

