/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.browser.BrowserExt;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WebBrowserUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ui.browser";
    private static WebBrowserUIPlugin singleton;
    private static List<BrowserExt> browsers;

    public WebBrowserUIPlugin() {
        singleton = this;
    }

    public static WebBrowserUIPlugin getInstance() {
        return singleton;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        BrowserManager.safeDispose();
    }

    public static IBrowserExt[] getBrowsers() {
        if (browsers == null) {
            WebBrowserUIPlugin.loadBrowsers();
        }
        IBrowserExt[] c = new IBrowserExt[browsers.size()];
        browsers.toArray(c);
        return c;
    }

    public static IBrowserExt findBrowsers(String executable) {
        IBrowserExt[] browsers2 = WebBrowserUIPlugin.getBrowsers();
        if (browsers2 == null || executable == null) {
            return null;
        }
        int ind1 = executable.lastIndexOf(47);
        int ind2 = executable.lastIndexOf(92);
        if (ind2 > ind1) {
            ind1 = ind2;
        }
        executable = executable.substring(ind1 + 1);
        String os = Platform.getOS();
        int size = browsers2.length;
        int i = 0;
        while (i < size) {
            String executable2;
            if (browsers2[i].getOS().toLowerCase().contains(os) && browsers2[i].isAvailable() && executable.startsWith(executable2 = browsers2[i].getExecutable())) {
                return browsers2[i];
            }
            ++i;
        }
        return null;
    }

    private static synchronized void loadBrowsers() {
        if (browsers != null) {
            return;
        }
        Trace.trace(Trace.CONFIG, "->- Loading .browsers extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor(PLUGIN_ID, "browsers");
        int size = cf.length;
        browsers = new ArrayList<BrowserExt>(size);
        int i = 0;
        while (i < size) {
            try {
                browsers.add(new BrowserExt(cf[i]));
                Trace.trace(Trace.CONFIG, "  Loaded browser: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load browser: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.CONFIG, "-<- Done loading .browsers extension point -<-");
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        WebBrowserUIPlugin.getInstance().getLog().error(message, ex);
    }
}

