/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public interface PortForwardingInformationProvider {
    public List<SshdSocketAddress> getStartedLocalPortForwards();

    public List<SshdSocketAddress> getBoundLocalPortForwards(int var1);

    public List<Map.Entry<SshdSocketAddress, SshdSocketAddress>> getLocalForwardsBindings();

    default public boolean isLocalPortForwardingStartedForPort(int port) {
        return GenericUtils.isNotEmpty(this.getBoundLocalPortForwards(port));
    }

    public NavigableSet<Integer> getStartedRemotePortForwards();

    public SshdSocketAddress getBoundRemotePortForward(int var1);

    public List<Map.Entry<Integer, SshdSocketAddress>> getRemoteForwardsBindings();

    default public boolean isRemotePortForwardingStartedForPort(int port) {
        return this.getBoundRemotePortForward(port) != null;
    }
}

