/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.platform.internal.ui.commands;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.platform.internal.ui.commands.Utils;
import org.eclipse.rcptt.ecl.platform.ui.commands.ExecuteCommand;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class ExecuteCommandService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IHandlerService service = (IHandlerService)workbench.getService(IHandlerService.class);
        if (service == null) {
            return Utils.error("Handler service is unavailable");
        }
        ExecuteCommand typed = (ExecuteCommand)command;
        String id = typed.getCommandId();
        CompletableFuture result = new CompletableFuture();
        workbench.getDisplay().asyncExec(() -> {
            try {
                workbench.getDisplay().asyncExec(() -> {
                    boolean bl = result.complete(Status.OK_STATUS);
                });
                service.executeCommand(id, null);
                result.complete(Status.OK_STATUS);
            }
            catch (NotEnabledException | NotHandledException | NotDefinedException e) {
                result.complete(Utils.error("Command " + id + " is unavailable", e));
            }
            catch (Throwable e) {
                result.complete(Utils.error("Command " + id + " has failed", e));
            }
        });
        try {
            return (IStatus)result.get(1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return Utils.error("UI thread has timed out");
        }
        catch (ExecutionException e) {
            return Utils.error("Unexpected completion result", e);
        }
    }
}

