/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.index;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.internal.core.model.index.IProjectIndexer;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.IndexRequest;
import org.eclipse.rcptt.internal.core.model.index.ReadWriteMonitor;

public class NamedElementRequest
extends IndexRequest {
    protected final IQ7NamedElement element;

    public NamedElementRequest(IProjectIndexer indexer, IQ7NamedElement element) {
        super(indexer);
        this.element = element;
    }

    @Override
    protected String getName() {
        return this.element.getName();
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.element.getQ7Project().getName());
    }

    @Override
    protected void run() throws CoreException, IOException {
        IQ7Project project = this.element.getQ7Project();
        Index index = this.getIndexer().getProjectIndex(project);
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            this.getIndexer().indexNamedElement(index, this.element);
            index.save();
        }
        finally {
            imon.exitWrite();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedElementRequest other = (NamedElementRequest)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }
}

