/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.server.tcp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.server.tcp.SessionManager;

public class EclTcpServer
extends Thread {
    private final ServerSocket socket;
    private final int port;
    private volatile boolean starting = true;
    private SessionManager manager = null;

    public boolean isStarting() {
        return this.starting;
    }

    public EclTcpServer(int port, boolean useJobs) throws IOException {
        super("ECL TCP server: " + port + " main");
        this.socket = new ServerSocket(port);
        this.port = port;
        this.manager = new SessionManager(useJobs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.starting = false;
        try {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ServerSocket closeable = this.socket;){
                    while (!this.isInterrupted()) {
                        try {
                            Socket client = this.socket.accept();
                            client.setTcpNoDelay(true);
                            this.manager.acceptNewConnection(client);
                        }
                        catch (Exception e) {
                            if (this.socket.isClosed()) continue;
                            CorePlugin.log((IStatus)CorePlugin.err((String)"Failed to accept connection", (Throwable)e));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (Exception e) {
                CorePlugin.log((IStatus)CorePlugin.err((String)"Failed to start ECL TCP server", (Throwable)e));
                CorePlugin.log((String)String.format("ECL TCP server on port %d has stopped", this.port));
                return;
            }
        }
        catch (Throwable throwable) {
            CorePlugin.log((String)String.format("ECL TCP server on port %d has stopped", this.port));
            throw throwable;
        }
        CorePlugin.log((String)String.format("ECL TCP server on port %d has stopped", this.port));
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void interrupt() {
        try {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            super.interrupt();
        }
    }
}

