/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.emf.ui.providers.labelproviders.DelegatingToEMFLabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.papyrus.model2doc.integration.architecture.internal.messages.Messages;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.Activator;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.commands.CreateDocumentTemplateEditorViewCommand;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.command.ICreateDocumentTemplateEditorCommand;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCreateDocumentTemplateEditorCommand
implements ICreateDocumentTemplateEditorCommand {
    protected String askDocumentName(String dialogTitle, String proposedName) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), dialogTitle, Messages.AbstractCreateDocumentTemplateEditorCommand_DialogMessage, proposedName, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    protected DocumentTemplate execute(DocumentTemplatePrototype documentTemplatePrototype, String documentName, EObject semanticContext, boolean openAfterCreation) {
        return this.execute(documentTemplatePrototype, documentName, semanticContext, semanticContext, openAfterCreation);
    }

    protected DocumentTemplate execute(DocumentTemplatePrototype documentTemplatePrototype, String documentName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        Resource res = semanticContext.eResource();
        URI semanticURI = res.getURI();
        if (semanticURI.isPlatformPlugin()) {
            Activator.log.error((Throwable)new UnsupportedOperationException("Documentation for element stored as platform plugin is not yet supported"));
            return null;
        }
        TransactionalEditingDomain domain = this.getEditingDomain(semanticContext);
        if (domain == null) {
            return null;
        }
        String documentMainTitle = this.getDocumentMainTitle(semanticContext);
        CreateDocumentTemplateEditorViewCommand command = this.createDocumentTemplateEditorCreationCommand(domain, documentTemplatePrototype, documentName, documentMainTitle, semanticContext, openAfterCreation);
        domain.getCommandStack().execute((Command)command);
        return (DocumentTemplate)command.getCreatedEditorView();
    }

    public CreateDocumentTemplateEditorViewCommand createDocumentTemplateEditorCreationCommand(TransactionalEditingDomain editingDomain, DocumentTemplatePrototype documentPrototype, String documentName, String documentMainTitle, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation) {
        return new CreateDocumentTemplateEditorViewCommand(editingDomain, documentPrototype, documentName, documentMainTitle, semanticContext, graphicalContext, openAfterCreation);
    }

    public CreateDocumentTemplateEditorViewCommand createDocumentTemplateEditorCreationCommand(TransactionalEditingDomain editingDomain, DocumentTemplatePrototype documentPrototype, String documentName, String documentMainTitle, EObject semanticContext, boolean openAfterCreation) {
        return new CreateDocumentTemplateEditorViewCommand(editingDomain, documentPrototype, documentName, documentMainTitle, semanticContext, openAfterCreation);
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    protected final TransactionalEditingDomain getEditingDomain(EObject modelElement) {
        ServicesRegistry servicesRegistry = this.getServiceRegistry(modelElement);
        if (servicesRegistry == null) {
            return null;
        }
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("EditingDomain not found", (Throwable)e);
            return null;
        }
    }

    protected String getDocumentMainTitle(EObject semanticContext) {
        return DelegatingToEMFLabelProvider.INSTANCE.getText((Object)semanticContext);
    }
}

