/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.model2doc.core.author.IAuthor;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocumentPart;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentPart;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.TextDocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class TextDocumentTemplateMapper
extends AbstractTemplateToStructureMapper<TextDocumentTemplate> {
    public TextDocumentTemplateMapper() {
        super(DocumentStructureTemplatePackage.eINSTANCE.getTextDocumentTemplate(), Document.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, TextDocumentTemplate input, EObject modelElement, Class<T> expectedReturnedClass) {
        TextDocument txtDocument = DocumentStructureFactory.eINSTANCE.createTextDocument();
        txtDocument.setMainTitle(input.getMainTitle());
        IDocumentStructureGeneratorConfiguration structureGeneratorConfig = input.getDocumentStructureGeneratorConfiguration();
        IDocumentGeneratorConfiguration docGeneratorConfig = structureGeneratorConfig.createDocumentGeneratorConfiguration();
        txtDocument.setDocumentGeneratorConfiguration(docGeneratorConfig);
        Iterator authors = input.getAuthors().iterator();
        while (authors.hasNext()) {
            IAuthor copiedAuthor = (IAuthor)EcoreUtil.copy((EObject)((IAuthor)authors.next()));
            txtDocument.getAuthors().add((Object)copiedAuthor);
        }
        EObject semanticContext = input.getSemanticContext();
        EList parts = input.getDocumentParts();
        for (DocumentPart current : parts) {
            List<TextDocumentPart> result = mappingService.map((EObject)current, semanticContext, TextDocumentPart.class);
            if (result == null) continue;
            txtDocument.getTextDocumentParts().addAll(result);
        }
        return Collections.singletonList(expectedReturnedClass.cast(txtDocument));
    }
}

