/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.docx.internal.util;

import java.util.Arrays;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class TextUtils {
    private static final String DROP_LINE = "\n";
    private static final String TAB = "\t";
    private static final List<String> CHARS_TO_CONVERT = Arrays.asList("\n", "\t");

    public static void fillParagraph(XWPFParagraph p, String text) {
        block13: {
            if (text == null) break block13;
            String subString = text;
            while (!subString.isEmpty()) {
                String[] splittedString;
                block14: {
                    int min = -1;
                    String splitDelimiter = "";
                    for (String s : CHARS_TO_CONVERT) {
                        String[] replacement = subString.split(s, 2);
                        if (min == -1) {
                            min = replacement[0].length();
                            splitDelimiter = s;
                            continue;
                        }
                        if (min == -1 || replacement[0].length() >= min) continue;
                        min = replacement[0].length();
                        splitDelimiter = s;
                    }
                    splittedString = subString.split(splitDelimiter, 2);
                    String firstPart = splittedString[0];
                    XWPFRun newRun = p.createRun();
                    newRun.setText(firstPart);
                    if (splittedString.length <= 1) break block14;
                    switch (splitDelimiter) {
                        case "\n": {
                            newRun.addBreak();
                            break;
                        }
                        case "\t": {
                            newRun.addTab();
                            break;
                        }
                    }
                }
                subString = splittedString.length > 1 ? splittedString[1] : "";
            }
        }
    }
}

