/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class ProxyUtil {
    public static boolean isAuthConnSupported() {
        try {
            Class.forName("org.eclipse.core.net.proxy.IProxyService");
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static IProxyData getProxy(URL url) {
        URI uri;
        IProxyService service;
        block6: {
            if (!ProxyUtil.isAuthConnSupported()) {
                return null;
            }
            service = ProxyManager.getProxyManager();
            if (!service.isProxiesEnabled()) {
                return null;
            }
            try {
                uri = url.toURI();
                if (!ProxyUtil.shouldBypass(uri)) break block6;
                return null;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        IProxyData[] data = service.select(uri);
        if (data.length == 0) {
            return null;
        }
        return data[0];
    }

    public static boolean shouldBypass(URI uri) {
        String host = uri.getHost();
        if (host == null) {
            return true;
        }
        List<String> hosts = ProxyUtil.getProxyBypassHosts();
        if (hosts.contains(host)) {
            return true;
        }
        return (host.equals("localhost") || host.equals("127.0.0.1")) && hosts.contains("<local>");
    }

    public static List<String> getProxyBypassHosts() {
        ArrayList<String> hosts = new ArrayList<String>();
        if (!ProxyUtil.isAuthConnSupported()) {
            return hosts;
        }
        IProxyService service = ProxyManager.getProxyManager();
        String[] manuals = service.getNonProxiedHosts();
        String[] natives = null;
        if (service instanceof ProxyManager) {
            natives = ((ProxyManager)service).getNativeNonProxiedHosts();
        }
        Collections.addAll(hosts, manuals);
        if (natives != null) {
            Collections.addAll(hosts, natives);
        }
        return hosts;
    }

    public static URLConnection getConnection(URL url) throws IOException {
        IProxyData data = ProxyUtil.getProxy(url);
        if (data == null) {
            return url.openConnection();
        }
        if (data.isRequiresAuthentication()) {
            Authenticator.setDefault(new ProxyAuthenticator(data.getUserId(), data.getPassword()));
        } else {
            Authenticator.setDefault(null);
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(data.getHost(), data.getPort()));
        return url.openConnection(proxy);
    }

    public static InputStream getStream(URL url) throws IOException {
        return ProxyUtil.getConnection(url).getInputStream();
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final String user;
        private final String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }
}

