/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.model.edit.provider.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.emde.extension.i18n.Messages;
import org.polarsys.kitalpha.emde.extension.utils.EMFHelper;
import org.polarsys.kitalpha.emde.extension.utils.ExtensionAnnotationsHelper;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public final class EMDEHelper {
    public static final EPackage.Registry packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    public static final IPath FRAGMENT_PATH = new Path("fragment.xml");
    public static final IPath MANIFEST_PATH = new Path("META-INF/MANIFEST.MF");
    public static final IPath PLUGIN_PATH = new Path("plugin.xml");

    public static Collection<EClass> getExtendedElementEClasses(BasicDiagnostic basicDiagnostic, EClass eClass) {
        UniqueEList eClasses = new UniqueEList();
        if (eClass == null || eClass.eResource() == null) {
            return eClasses;
        }
        for (String detail : ExtensionAnnotationsHelper.getExtendedElement((EClass)eClass)) {
            URI uri = URI.createURI((String)detail);
            if (uri.isRelative()) {
                basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_ExtendedElement_Relative_URI_Error, (Object)eClass.getName(), (Object)detail), null));
            }
            try {
                String fragment = uri.fragment();
                URI nsURI = uri.trimFragment();
                EClass eClassTmp = EMDEHelper.getEClassFromPackageRegistry(nsURI, fragment);
                if (eClassTmp != null) {
                    eClasses.add(eClassTmp);
                    continue;
                }
                URI ecoreURI = EMDEHelper.getPlatformEcoreURIFromGenModel(nsURI);
                if (ecoreURI == null) continue;
                uri = ecoreURI.appendFragment(fragment);
            }
            catch (WrappedException wrappedException) {
                basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_ExtendedElement_URI_Error, (Object)eClass.getName(), (Object)detail), null));
            }
            catch (RuntimeException runtimeException) {
                basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_ExtendedElement_Resource_Error, (Object)eClass.getName(), (Object)detail), null));
            }
        }
        return eClasses;
    }

    public static EClass getEClassFromPackageRegistry(URI namespaceURI, String fragment) {
        EClassifier eClassifier;
        EPackage ePackage;
        if (fragment == null) {
            return null;
        }
        int index = fragment.indexOf("//");
        if (index != -1 && fragment.length() > index + 2) {
            fragment = fragment.substring(index + 2);
        }
        if ((ePackage = packageRegistry.getEPackage(namespaceURI.toString())) != null && (eClassifier = ePackage.getEClassifier(fragment)) instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    public static URI getPlatformEcoreURIFromGenModel(URI namespaceURI) {
        URI genModelURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(namespaceURI.toString());
        if (genModelURI != null) {
            return EMDEHelper.getEcoreURIFromGenModel(namespaceURI, genModelURI);
        }
        return null;
    }

    public static URI getEcoreURIFromGenModel(URI namespaceURI, URI genModelURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource genModelResource = resourceSet.getResource(genModelURI, true);
            EcoreUtil.resolveAll((Resource)genModelResource);
            for (Resource resource : resourceSet.getResources()) {
                EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
                    private static final long serialVersionUID = 1L;

                    protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                        return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
                    }
                };
                while (j.hasNext()) {
                    EPackage ePackage;
                    Object content = j.next();
                    if (!(content instanceof EPackage) || !(ePackage = (EPackage)content).getNsURI().toString().equals(namespaceURI.toString())) continue;
                    URI uRI = resource.getURI();
                    return uRI;
                }
            }
        }
        finally {
            EMDEHelper.clear((ResourceSet)resourceSet);
        }
        return null;
    }

    public static Collection<EClass> getExtendedElement(BasicDiagnostic basicDiagnostic, EClass eClass) {
        Collection<EClass> eClasses = EMDEHelper.getExtendedElementEClasses(basicDiagnostic, eClass);
        if (!eClasses.isEmpty()) {
            return eClasses;
        }
        return EMDEHelper.getExtendedElementParentEClasses(basicDiagnostic, eClass);
    }

    public static Collection<EClass> getExtendedElementParentEClasses(BasicDiagnostic basicDiagnostic, EClass eClass) {
        UniqueEList eClasses = new UniqueEList();
        if (eClass == null || eClass.eResource() == null) {
            return eClasses;
        }
        EList eSuperTypes = eClass.getESuperTypes();
        if (!eSuperTypes.isEmpty()) {
            eClasses.addAll(EMDEHelper.getExtendedElementEClasses(basicDiagnostic, (EClass)eSuperTypes.get(0)));
            if (eClasses.isEmpty()) {
                return EMDEHelper.getExtendedElementParentEClasses(basicDiagnostic, (EClass)eSuperTypes.get(0));
            }
        }
        return eClasses;
    }

    public static boolean isExtensibleElement(EClass object) {
        return EMDEHelper.isSuperTypeOf(object, EmdePackage.Literals.EXTENSIBLE_ELEMENT);
    }

    public static boolean isPluginProject(IProject project) {
        if (project.isOpen()) {
            return project.exists(MANIFEST_PATH) || project.exists(PLUGIN_PATH) || project.exists(FRAGMENT_PATH);
        }
        return false;
    }

    public static boolean isSuperTypeOf(EClass eClass, EClass type) {
        EClass stype;
        EClass seClass = (EClass)EMFHelper.solveAgainstStaticPackage((EClassifier)eClass);
        if (seClass == (stype = (EClass)EMFHelper.solveAgainstStaticPackage((EClassifier)type))) {
            return true;
        }
        for (EClass superType : seClass.getEAllSuperTypes()) {
            if ((superType = (EClass)EMFHelper.solveAgainstStaticPackage((EClassifier)superType)) != stype) continue;
            return true;
        }
        return false;
    }

    public static void validateExtendedElement(BasicDiagnostic basicDiagnostic, EClass eClass) {
        Collection<EClass> eClasses = EMDEHelper.getExtendedElementEClasses(basicDiagnostic, eClass);
        if (eClasses.isEmpty()) {
            return;
        }
        EClass seClass = (EClass)EMFHelper.solveAgainstStaticPackage((EClassifier)eClass);
        if (!EMDEHelper.isSuperTypeOf(seClass, EmdePackage.Literals.ELEMENT_EXTENSION)) {
            basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_EMDE_Annotation_ElementExtension_Type_Error, (Object)eClass.getName()), null));
            return;
        }
        Collection<EClass> parentExtendedElements = EMDEHelper.getExtendedElementParentEClasses(basicDiagnostic, eClass);
        for (EClass extendedElement : eClasses) {
            if (!EMDEHelper.isSuperTypeOf(extendedElement, EmdePackage.Literals.EXTENSIBLE_ELEMENT)) {
                basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_EMDE_Annotation_Element_Type_Error, (Object)eClass.getName(), (Object)extendedElement.getName()), null));
            }
            for (EClass innerExtendedElement : eClasses) {
                if (extendedElement == innerExtendedElement || !EMDEHelper.isSuperTypeOf(extendedElement, innerExtendedElement)) continue;
                basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_EMDE_Annotation_Element_SubType_Error, (Object[])new Object[]{eClass.getName(), innerExtendedElement.getName(), extendedElement.getName()}), null));
            }
            if (parentExtendedElements.isEmpty()) continue;
            boolean found = false;
            for (EClass parentExtendedElement : parentExtendedElements) {
                if (!EMDEHelper.isSuperTypeOf(extendedElement, parentExtendedElement)) continue;
                found = true;
                break;
            }
            if (found) continue;
            basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, "org.polarsys.kitalpha.emde", 0, NLS.bind((String)Messages._UI_GeneratingModelClass_EMDE_Annotation_Element_Parent_SubType_Error, (Object[])new Object[]{eClass.getName(), extendedElement.getName()}), null));
        }
    }

    private static void clear(ResourceSet set) {
        for (Resource r : set.getResources()) {
            r.unload();
        }
        set.getResources().clear();
    }
}

