/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramImageUtils;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.impl.DEdgeImpl;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SiriusNoteEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusDiagramSVGGenerator;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.internal.GenDocDiagramEditPartService;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenDiagramPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeStatus;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.IDiagramHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.SiriusHelper;

public class CoordinatesCalculator {
    public static final Map<String, Map<Rectangle, EObject>> COORDINATES_MAP = new HashMap<String, Map<Rectangle, EObject>>();
    private final GenDocDiagramEditPartService tool = new GenDocDiagramEditPartService();
    private IFile imageFile;
    private DDiagram diagram;
    private Collection<IDiagramHelper> helpers;
    private static Map<String, IDiagramHelper> helperMap = new HashMap<String, IDiagramHelper>();
    private Session session;
    private double scalingFactor = 1.0;
    private static IProgressMonitor progressMonitor = new NullProgressMonitor();
    private static final MyComparator MY_COMPARATOR = new MyComparator();

    public CoordinatesCalculator(IFile imageFile, DDiagram diagram, IDiagramHelper filter) {
        this(imageFile, diagram, filter, null);
    }

    private ImageReader getImageReader() {
        return ImageIO.getImageReadersBySuffix(DocgenDiagramPreferencesHelper.getImageFileExtension()).next();
    }

    public CoordinatesCalculator(IFile imageFile, DDiagram diagram, IDiagramHelper filter, Session session) {
        this.imageFile = imageFile;
        if (diagram.eIsProxy()) {
            this.resolveProxy(diagram, session);
        } else {
            this.diagram = diagram;
        }
        this.helpers = new HashSet<IDiagramHelper>();
        this.helpers.add(filter);
        this.session = session != null ? session : this.getSessionFromDiagram(diagram);
    }

    public void contributeHelpers(Collection<IDiagramHelper> helpers) {
        this.helpers.addAll(helpers);
    }

    private void resolveProxy(DDiagram diagram, Session session) {
        URI diagramUri = EcoreUtil.getURI((EObject)diagram);
        if (diagramUri != null && this.session == null) {
            EcoreUtil.getURI((EObject)diagram).trimFragment();
            this.session = SessionManager.INSTANCE.getSession(diagramUri.trimFragment(), progressMonitor);
        }
        this.diagram = (DDiagram)EcoreUtil.resolve((EObject)diagram, (Resource)this.session.getSessionResource());
    }

    private Session getSessionFromDiagram(DDiagram diagram) {
        if (diagram instanceof DSemanticDiagram) {
            return SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram).getTarget());
        }
        return null;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public Map<Rectangle, EObject> getPositionMap() {
        if (this.diagram == null || this.imageFile == null || !this.imageFile.exists()) {
            return Collections.emptyMap();
        }
        final LinkedHashMap<Rectangle, EObject> result = new LinkedHashMap<Rectangle, EObject>();
        final String diagramId = EcoreUtil.getURI((EObject)this.diagram).fragment();
        if (COORDINATES_MAP.containsKey(diagramId)) {
            Map<Rectangle, EObject> map = COORDINATES_MAP.get(diagramId);
            if (!map.isEmpty()) {
                result.putAll(map);
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.putAll(CoordinatesCalculator.this.getResultMap());
                        if (!result.isEmpty()) {
                            COORDINATES_MAP.put(diagramId, result);
                        }
                    }
                    catch (Exception e) {
                        Activator.logWarning(e.getMessage());
                    }
                }
            });
        }
        return this.removeObjectOutOfScope(result);
    }

    private Map<Rectangle, EObject> removeObjectOutOfScope(Map<Rectangle, EObject> postitions) {
        if (GenerationGlobalScope.getInstance().getScopeStatus().equals((Object)ScopeStatus.LIMITED)) {
            LinkedHashMap<Rectangle, EObject> result = new LinkedHashMap<Rectangle, EObject>();
            for (Map.Entry<Rectangle, EObject> entry : postitions.entrySet()) {
                boolean isInScope;
                EObject value = entry.getValue();
                if (value instanceof DRepresentationDescriptor) {
                    Collection allRepresentations;
                    DDiagram candidateDiagram;
                    isInScope = GenerationGlobalScope.getInstance().isCopyInScope(((DRepresentationDescriptor)value).getTarget());
                    if (!isInScope || !((candidateDiagram = DiagramSessionHelper.findCorrespondingDiagram((DRepresentationDescriptor)value, allRepresentations = DialectManager.INSTANCE.getAllRepresentations(this.session))) instanceof DSemanticDiagram)) continue;
                    result.put(entry.getKey(), value);
                    continue;
                }
                isInScope = GenerationGlobalScope.getInstance().isCopyInScope(value);
                if (!isInScope) continue;
                result.put(entry.getKey(), value);
            }
            return result;
        }
        return postitions;
    }

    private boolean acceptView(View view) {
        EObject element = view.getElement();
        EObject eContainer = view.eContainer();
        EObject containerView = eContainer;
        if (containerView instanceof View) {
            EObject containerElement = ((View)containerView).getElement();
            return !containerElement.equals(element);
        }
        throw new IllegalArgumentException("Illegal parameter: Class -> " + this.getClass().getName() + ", method -> acceptView(View view)");
    }

    @Deprecated
    public Map<Rectangle, EObject> getRectanglesMap(View view, Map<?, ?> registry, int deltaX, int deltaY) {
        LinkedHashMap<Rectangle, EObject> result = new LinkedHashMap<Rectangle, EObject>();
        GraphicalEditPart gep = (GraphicalEditPart)registry.get(view);
        if (gep != null) {
            EObject nodeElement = view.getElement();
            if (gep instanceof SiriusNoteEditPart && ((SiriusNoteEditPart)gep).isRepresentationLink()) {
                if (nodeElement instanceof DRepresentationDescriptor) {
                    boolean acceptView;
                    DRepresentationDescriptor descriptor = (DRepresentationDescriptor)nodeElement;
                    Rectangle bounds = null;
                    bounds = gep.getFigure().getBounds();
                    bounds = bounds.getCopy();
                    this.scale((Translatable)bounds);
                    if (bounds != null) {
                        bounds.performTranslate(deltaX, deltaY);
                    }
                    if (acceptView = this.acceptView(view)) {
                        result.put(bounds, (EObject)descriptor);
                    }
                }
            } else if (nodeElement instanceof DDiagramElement) {
                DDiagramElement element = (DDiagramElement)nodeElement;
                EObject eObject = this.getSemanticElement(element);
                Rectangle bounds = null;
                if (view instanceof Edge) {
                    if (gep.getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
                        originalBound = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)gep.getFigure()).getFigureViewEdgeNameFigure().getBounds();
                        bounds = new Rectangle(originalBound);
                    }
                } else {
                    originalBound = gep.getFigure().getBounds();
                    bounds = new Rectangle(originalBound);
                }
                this.scale((Translatable)bounds);
                if (bounds != null) {
                    bounds.performTranslate(deltaX, deltaY);
                }
                boolean acceptView = this.acceptView(view);
                if (!(view instanceof Edge)) {
                    EList children = view.getChildren();
                    for (Object object : children) {
                        int newDeltaY;
                        int newDeltaX;
                        Map<Rectangle, EObject> rectanglesMap;
                        if (!(object instanceof View) || (rectanglesMap = this.getRectanglesMap((View)object, registry, newDeltaX = acceptView && !this.isBorderedNode((View)object) ? bounds.x + 5 : deltaX, newDeltaY = acceptView && !this.isBorderedNode((View)object) ? bounds.y + 6 : deltaY)).isEmpty()) continue;
                        result.putAll(rectanglesMap);
                    }
                }
                if (acceptView && this.helpers.stream().anyMatch(help -> help.select(eObject))) {
                    result.put(bounds, eObject);
                }
            }
        }
        return result;
    }

    public Map<Rectangle, EObject> getInfoRectangleMap(PartPositionInfo info, Map<?, ?> registry, int deltaX, int deltaY) {
        LinkedHashMap<Rectangle, EObject> result = new LinkedHashMap<Rectangle, EObject>();
        EObject nodeElement = info.getView().getElement();
        View view = info.getView();
        Rectangle bounds = new Rectangle(info.getPartX(), info.getPartY(), info.getPartWidth(), info.getPartHeight());
        if (nodeElement instanceof DRepresentationDescriptor) {
            DRepresentationDescriptor descriptor = (DRepresentationDescriptor)nodeElement;
            boolean acceptView = this.acceptView(view);
            if (acceptView) {
                result.put(bounds, (EObject)descriptor);
            }
        } else if (nodeElement instanceof DDiagramElement) {
            boolean acceptView;
            GraphicalEditPart gep;
            DDiagramElement element = (DDiagramElement)nodeElement;
            EObject eObject = this.getSemanticElement(element);
            if (view instanceof Edge && (gep = (GraphicalEditPart)registry.get(view)).getFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
                Rectangle originalBound = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)gep.getFigure()).getFigureViewEdgeNameFigure().getBounds();
                bounds = new Rectangle(originalBound);
                this.scale((Translatable)bounds);
                if (bounds != null) {
                    bounds.performTranslate(deltaX, deltaY);
                }
            }
            if ((acceptView = this.acceptView(view)) && this.helpers.stream().anyMatch(help -> help.select(eObject))) {
                result.put(bounds, eObject);
            }
        }
        return result;
    }

    private Map<Rectangle, EObject> getResultMap() {
        Diagram gmfDiagram = this.getDiagram();
        if (gmfDiagram != null) {
            if (gmfDiagram.eIsProxy()) {
                gmfDiagram = (Diagram)EcoreUtil.resolve((EObject)gmfDiagram, (EObject)gmfDiagram.eContainer());
            }
            Shell shell = new Shell();
            DiagramEditPart diagramEP = this.tool.createDiagramEditPart(gmfDiagram, shell, PreferencesHint.USE_DEFAULTS);
            diagramEP.getRoot().refresh();
            diagramEP.getFigure().validate();
            diagramEP.getRoot().refresh();
            EditPartViewer viewer = diagramEP.getViewer();
            viewer.flush();
            Map registry = viewer.getEditPartRegistry();
            Dimension imageSize = this.getImageSize();
            int width = imageSize.width;
            int height = imageSize.height;
            Rectangle imageBounds = DiagramImageUtils.calculateImageRectangle((List)diagramEP.getPrimaryEditParts(), (double)10.0, (Dimension)new Dimension(10, 10));
            this.scalingFactor = SiriusHelper.initAutoScaling(this.tool, diagramEP);
            this.scale((Translatable)imageBounds);
            int deltaX = imageBounds.getTopRight().x - width;
            int deltaY = imageBounds.getBottomLeft().y - height;
            LinkedHashMap<Rectangle, EObject> result = new LinkedHashMap<Rectangle, EObject>();
            SiriusDiagramSVGGenerator gen = new SiriusDiagramSVGGenerator(diagramEP, true);
            List infos = gen.getDiagramPartInfo();
            infos.stream().filter(info -> info.getView().getElement() != null).forEach(info -> result.putAll(this.getInfoRectangleMap((PartPositionInfo)info, registry, -deltaX, -deltaY)));
            this.cleanGenerationData(gmfDiagram, shell, diagramEP);
            return result;
        }
        return Collections.emptyMap();
    }

    private void scale(Translatable t) {
        double factor = this.getScalingFactor();
        if (factor < 1.0 && t != null) {
            t.performScale(factor);
        }
    }

    private boolean edgeHasCenterLabel(View view, Map<?, ?> registry) {
        EObject element = view.getElement();
        if (element instanceof DEdgeImpl) {
            String name = ((DEdgeImpl)element).getName();
            return name != null && name.trim().length() > 0;
        }
        return false;
    }

    private void cleanGenerationData(Diagram gmfDiagram, Shell shell, DiagramEditPart diagramEP) {
        shell.dispose();
        diagramEP.deactivate();
        diagramEP.getViewer().flush();
        CommandStack commandStack = diagramEP.getViewer().getEditDomain().getCommandStack();
        commandStack.flush();
        if (diagramEP.getViewer().getControl() != null) {
            diagramEP.getViewer().getControl().dispose();
        }
        ((DiagramEditDomain)diagramEP.getViewer().getEditDomain()).removeViewer(diagramEP.getViewer());
        DiagramEventBroker.stopListening((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)gmfDiagram));
        if (commandStack instanceof DiagramCommandStack) {
            IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
            operationHistory.dispose(((DiagramCommandStack)commandStack).getUndoContext(), true, true, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dimension getImageSize() {
        try {
            if (this.imageFile == null) return new Dimension(-1, -1);
            if (!this.imageFile.exists()) return new Dimension(-1, -1);
            String fullPath = this.imageFile.getLocation().toString();
            try (ImageInputStream imageInputStream = null;){
                imageInputStream = ImageIO.createImageInputStream(new File(fullPath));
                ImageReader reader = this.getImageReader();
                reader.setInput(imageInputStream);
                if (reader.getInput() == null) return new Dimension(-1, -1);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                return dimension;
            }
        }
        catch (Exception e) {
            Activator.logWarning(e.getMessage());
        }
        return new Dimension(-1, -1);
    }

    private Diagram getDiagram() {
        for (AnnotationEntry annotationEntry : this.diagram.getOwnedAnnotationEntries()) {
            EObject data;
            if (!annotationEntry.getSource().equals("GMF_DIAGRAMS") || !((data = annotationEntry.getData()) instanceof Diagram)) continue;
            return (Diagram)data;
        }
        Resource airdResource = this.diagram.eResource() != null ? this.diagram.eResource() : this.session.getSessionResource();
        TreeIterator allContents = airdResource.getAllContents();
        while (allContents.hasNext()) {
            Diagram gmfDiag;
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof Diagram) || !EcoreUtil.equals((EObject)(gmfDiag = (Diagram)eObject).getElement(), (EObject)this.diagram)) continue;
            return gmfDiag;
        }
        return null;
    }

    private boolean isBorderedNode(View node) {
        EObject parent;
        EObject element = node.getElement();
        if (element instanceof DNode && (parent = element.eContainer()) instanceof AbstractDNode) {
            return ((AbstractDNode)parent).getOwnedBorderedNodes().contains((Object)element);
        }
        return false;
    }

    private EObject getSemanticElement(DDiagramElement element) {
        Collection semanticObjects = this.helpers.stream().map(help -> help.getSemanticElement(element)).filter(semElem -> semElem != null).collect(Collectors.toSet());
        if (!semanticObjects.isEmpty()) {
            IDiagramHelper semanticObjectHelper = null;
            for (EObject object : semanticObjects) {
                semanticObjectHelper = helperMap.get(object.getClass().getCanonicalName());
            }
            if (semanticObjectHelper == null) {
                for (EObject object : semanticObjects) {
                    Optional<IDiagramHelper> optHelp = this.helpers.stream().filter(help -> help.select(object)).findFirst();
                    if (!optHelp.isPresent()) continue;
                    helperMap.put(object.getClass().getCanonicalName(), optHelp.get());
                    return object;
                }
            } else {
                return semanticObjectHelper.getSemanticElement(element);
            }
        }
        return null;
    }

    @Deprecated
    private Map<Rectangle, EObject> proceed(Map<Rectangle, EObject> resultMap, Map<View, EObject> nodeMap) {
        HashMap<Rectangle, EObject> map = new HashMap<Rectangle, EObject>(resultMap);
        ArrayList<View> arrayList = new ArrayList<View>(nodeMap.keySet());
        Collections.sort(arrayList, MY_COMPARATOR);
        LinkedHashMap<Rectangle, EObject> result = new LinkedHashMap<Rectangle, EObject>();
        ArrayList<EObject> keyList = new ArrayList<EObject>();
        for (View node : arrayList) {
            EObject childObject = nodeMap.get(node);
            keyList.add(childObject);
            Rectangle childRectangle = this.getRectangle(map, childObject);
            this.translateContainedRectangle(map, node, childRectangle);
        }
        for (EObject key : keyList) {
            result.put(this.getRectangle(map, key), key);
        }
        return result;
    }

    @Deprecated
    private Rectangle getRectangle(Map<Rectangle, EObject> map, EObject modelElement) {
        for (Map.Entry<Rectangle, EObject> entry : map.entrySet()) {
            if (!entry.getValue().equals(modelElement)) continue;
            return entry.getKey();
        }
        throw new RuntimeException("Can't get rectable form model element: " + modelElement.toString());
    }

    @Deprecated
    private void translateContainedRectangle(Map<Rectangle, EObject> map, View node, Rectangle childRectangle) {
        if (!this.isBorderedNode(node)) {
            Set<EObject> parentList = this.getParentList(node);
            for (EObject parentObject : parentList) {
                Rectangle parentRectangle = this.getRectangle(map, parentObject);
                Point topLeft = parentRectangle.getTopLeft();
                childRectangle.performTranslate(topLeft.x + 5, topLeft.y + 6);
            }
        }
    }

    @Deprecated
    private Set<EObject> getParentList(View childNode) {
        HashSet<EObject> set = new HashSet<EObject>();
        EObject eContainer = childNode.eContainer();
        if (eContainer == null || eContainer instanceof Diagram) {
            return Collections.emptySet();
        }
        if (eContainer instanceof Node) {
            Node node = (Node)eContainer;
            EObject nodeElement = node.getElement();
            if (nodeElement instanceof DDiagramElement && this.helpers.stream().anyMatch(help -> help.isContainer((DDiagramElement)nodeElement))) {
                DDiagramElement element = (DDiagramElement)nodeElement;
                EObject eObject = this.getSemanticElement(element);
                set.add(eObject);
            }
            set.addAll(this.getParentList((View)node));
        }
        return set;
    }

    @Deprecated
    private List<Object> getChildren(View view) {
        ArrayList<Object> result = new ArrayList<Object>();
        EList children = view.getChildren();
        result.addAll((Collection<Object>)children);
        for (Object object : children) {
            if (!(object instanceof View)) continue;
            View child = (View)object;
            result.addAll(this.getChildren(child));
        }
        return result;
    }

    @Deprecated
    private void synchronizeDiagram(Diagram diagram, TransactionalEditingDomain domain) {
    }

    private static class MyComparator
    implements Comparator<EObject> {
        private MyComparator() {
        }

        @Override
        public int compare(EObject a, EObject b) {
            EObject bContainer;
            EObject aContainer = a.eContainer();
            if (EcoreUtil.equals((EObject)aContainer, (EObject)(bContainer = b.eContainer()))) {
                return 0;
            }
            if (aContainer == null) {
                return 1;
            }
            if (bContainer == null) {
                return -1;
            }
            return this.compare(aContainer, bContainer);
        }
    }
}

