/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.VpdescFactory;

public class VPDescModelManager {
    public static Viewpoint createVpsSpecModel(IProject project, String vpShortName, boolean save, EObject child, EObject extension) throws IOException {
        Viewpoint vpDescription = VPDescModelManager.createVpsSpecModel(project, vpShortName, false);
        if (child != null) {
            vpDescription.eContents().add((Object)child);
        }
        if (extension != null) {
            vpDescription.getVP_Aspects().add((Object)((Aspect)extension));
        }
        if (save) {
            VPDescModelManager.saveModel(project, (EObject)vpDescription, vpShortName);
        }
        return vpDescription;
    }

    public static Viewpoint createVpsSpecModel(IProject project, String vpShortName, boolean save, List<EObject> children, List<EObject> extensions) throws IOException {
        Viewpoint vpDescription = VPDescModelManager.createVpsSpecModel(project, vpShortName, false);
        if (children != null && !children.isEmpty()) {
            for (EObject eObject : children) {
                vpDescription.eContents().add((Object)eObject);
            }
        }
        if (extensions != null && !extensions.isEmpty()) {
            for (EObject eObject : extensions) {
                vpDescription.getVP_Aspects().add((Object)((Aspect)eObject));
            }
        }
        if (save) {
            VPDescModelManager.saveModel(project, (EObject)vpDescription, vpShortName);
        }
        return vpDescription;
    }

    public static Viewpoint createVpsSpecModel(IProject project, String vpShortName, boolean save) throws IOException {
        Viewpoint vpdescription = VpdescFactory.eINSTANCE.createViewpoint();
        Data data = VpdescFactory.eINSTANCE.createData();
        data.setName(String.valueOf(vpShortName) + ".data");
        vpdescription.setVP_Data(data);
        vpdescription.setShortName(vpShortName);
        vpdescription.setName(vpShortName);
        if (save) {
            VPDescModelManager.saveModel(project, (EObject)vpdescription, vpShortName);
        }
        return vpdescription;
    }

    public static void saveModel(IProject project, EObject rootObject, String vpShortName) throws IOException {
        String vpURI = String.valueOf('/') + project.getName() + '/' + "model" + '/' + vpShortName + '.' + "vpdesc";
        ResourceSetImpl set = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)vpURI, (boolean)false);
        Resource createResource = set.createResource(uri);
        createResource.getContents().add((Object)rootObject);
        createResource.save(Collections.EMPTY_MAP);
    }
}

