/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.task;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sirius.ui.tools.api.project.ViewpointSpecificationProject;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.util.DescriptionAdapterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.ExpressionKind;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.SiriusExpressionHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.util.VSMGenerationUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.PDEUtility;

public class CreateViewpointSpecificationProjectTask
implements ITaskProduction {
    private static final String DEFAUT_JAVA_SERVICE_NAME = "Services";
    private static final String SOURCE_FOLDER_NAME = "src/";

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        if (!VSMGenerationUtil.canExecuteTask(productionContext)) {
            return;
        }
        String modelName = (String)productionContext.getInputValue((Object)"model.name", String.class);
        final String modelNameWithextension = String.valueOf(modelName) + "." + ViewpointSpecificationProject.VIEWPOINT_MODEL_EXTENSION;
        final String designProjectName = (String)productionContext.getInputValue((Object)"design.project.name", String.class);
        String rootProjectName = (String)productionContext.getInputValue((Object)"root.project.name", String.class);
        final IProgressMonitor fmonitor = monitor;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(designProjectName);
                WorkspaceModifyOperation projectcreationOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        IFile odesignfile;
                        IFolder description;
                        boolean initialization = false;
                        if (!project.exists()) {
                            ViewpointSpecificationProject.createNewViewpointSpecificationProject((String)designProjectName, (String)modelNameWithextension);
                            initialization = true;
                        }
                        if (!(description = project.getFolder("description")).exists()) {
                            description.create(2, true, null);
                        }
                        if ((odesignfile = description.getFile(modelNameWithextension)).exists()) {
                            if (!initialization) {
                                CreateViewpointSpecificationProjectTask.this.copyOdesignFile(odesignfile, monitor);
                            }
                            try {
                                CreateViewpointSpecificationProjectTask.this.clearODesignModelContent(odesignfile, monitor);
                                if (initialization) {
                                    CreateViewpointSpecificationProjectTask.this.removeDefaultJavaService(project, CreateViewpointSpecificationProjectTask.DEFAUT_JAVA_SERVICE_NAME, monitor);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                try {
                    projectcreationOperation.run(fmonitor);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        this.updateProjectDependecies(designProjectName, rootProjectName);
    }

    private void removeDefaultJavaService(IProject project, String jserviceName, IProgressMonitor monitor) throws CoreException {
        if (project.exists()) {
            String name = project.getName();
            IFile serviceFile = project.getFile(SOURCE_FOLDER_NAME + name.replace('.', '/') + '/' + jserviceName + ".java");
            if (serviceFile.exists()) {
                serviceFile.delete(true, monitor);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, project.getName(), "Could not find project " + project.getName()));
        }
    }

    private void updateProjectDependecies(String designProjectName, String rootProjectName) throws InvocationException {
        ArrayList<String> requiredBundlesToAdd = new ArrayList<String>();
        ArrayList<String> dependenciesToRemove = new ArrayList<String>();
        requiredBundlesToAdd.add("org.eclipse.emf.ecore");
        requiredBundlesToAdd.add("org.eclipse.sirius.diagram");
        requiredBundlesToAdd.add(String.valueOf(rootProjectName) + ".model");
        ExpressionKind currentExpressionKind = SiriusExpressionHelper.getCurrentExpressionKind();
        switch (currentExpressionKind) {
            case QueryLegacy: {
                dependenciesToRemove.add("org.eclipse.sirius.common.acceleo.mtl");
                dependenciesToRemove.add("org.eclipse.sirius.common.acceleo.aql");
                requiredBundlesToAdd.add("org.eclipse.sirius.query.legacy");
                break;
            }
            case AQL: {
                requiredBundlesToAdd.add("org.eclipse.sirius.common.acceleo.aql");
            }
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(designProjectName);
        if (project != null && project.exists()) {
            PDEUtility.updateRequiredBundles((IProject)project, requiredBundlesToAdd, (IProgressMonitor)new NullProgressMonitor());
            PDEUtility.removeRequiredBundles((IProject)project, dependenciesToRemove, (IProgressMonitor)new NullProgressMonitor());
            try {
                project.build(6, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new InvocationException((Throwable)e);
            }
        }
    }

    private void clearODesignModelContent(IFile odesignfile, IProgressMonitor monitor) throws IOException {
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new DescriptionAdapterFactory(), (CommandStack)new BasicCommandStack());
        Resource resource = domain.createResource(odesignfile.getFullPath().toString());
        resource.load(Collections.EMPTY_MAP);
        EList content = resource.getContents();
        if (content != null && content.size() > 0) {
            EObject modelRootElement = (EObject)content.get(0);
            if (modelRootElement instanceof Group) {
                Group group = (Group)modelRootElement;
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)group);
                BasicEList viewpointList = new BasicEList();
                viewpointList.addAll((Collection)group.getOwnedViewpoints());
                CompoundCommand allRemoves = new CompoundCommand();
                for (EObject eObject : viewpointList) {
                    Command remove = RemoveCommand.create((EditingDomain)editingDomain, (Object)group, (Object)DescriptionPackage.eINSTANCE.getGroup_OwnedViewpoints(), (Object)eObject);
                    allRemoves.append(remove);
                }
                editingDomain.getCommandStack().execute((Command)allRemoves);
            }
            resource.save(Collections.EMPTY_MAP);
            resource.unload();
        }
    }

    private void copyOdesignFile(IFile odesignfile, IProgressMonitor monitor) throws CoreException {
        IProject project = odesignfile.getProject();
        IFolder oldDescription = project.getFolder("description_old");
        if (!oldDescription.exists()) {
            oldDescription.create(true, true, monitor);
        }
        String fileExt = odesignfile.getFileExtension();
        IPath copyPath = odesignfile.getFullPath();
        copyPath = copyPath.removeFileExtension();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
        String fileName = String.valueOf(copyPath.lastSegment()) + dateFormat.format(cal.getTime()) + "." + fileExt;
        IFile copyFile = oldDescription.getFile(fileName);
        odesignfile.copy(copyFile.getFullPath(), 2, monitor);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

