/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.constant.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java.JDTUtility;

public class JavaClassReporter
implements PatternExecutionReporter {
    public static final Integer dontSave = 0;
    public static final Integer whenExecutionFinished = 1;
    public static final Integer whenLoopFinished = 2;
    protected String collectedOutput = "";

    public final void executionFinished(String output, PatternContext context) {
        Integer saveTime = (Integer)context.getValue("savetime");
        if (saveTime == null || !whenExecutionFinished.equals(saveTime)) {
            return;
        }
        String projectName = (String)context.getValue("projectname");
        String packageName = (String)context.getValue("packagename");
        String className = (String)context.getValue("classname");
        if (projectName == null || projectName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Project);
        }
        if (packageName == null || packageName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Package);
        }
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Class);
        }
        if (this.collectedOutput != null && this.collectedOutput.trim().length() != 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IFolder folder = JDTUtility.createOrGetPackageFolders(project, packageName);
            IFile file = folder.getFile(String.valueOf(className) + ".java");
            JDTUtility.writeJavaContent(file, output);
        }
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
        Integer saveTime = (Integer)context.getValue("savetime");
        if (saveTime == null || !whenLoopFinished.equals(saveTime)) {
            this.collectedOutput = String.valueOf(this.collectedOutput) + output;
            return;
        }
        String projectName = (String)context.getValue("projectname");
        String packageName = (String)context.getValue("packagename");
        String className = (String)context.getValue("classname");
        if (projectName == null || projectName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Project);
        }
        if (packageName == null || packageName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Package);
        }
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Class);
        }
        if (whenLoopFinished.equals(saveTime)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IFolder folder = JDTUtility.createOrGetPackageFolders(project, packageName);
            IFile file = folder.getFile(String.valueOf(className) + ".java");
            String mergedcode = output;
            if (file.exists()) {
                mergedcode = JDTUtility.mergeJavaCode(file, output);
            }
            String codeWithCleanImportSction = JDTUtility.organizeImport(file, mergedcode);
            JDTUtility.writeJavaContent(file, codeWithCleanImportSction);
        }
    }
}

