/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.dialog;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Item;
import org.polarsys.kitalpha.ad.integration.sirius.SiriusViewpointManager;
import org.polarsys.kitalpha.ad.integration.sirius.dialog.ViewpointSelectionDialog;

public class ViewpointsTableLazyCellModifier
implements ICellModifier {
    protected final TableViewer tableViewer;
    protected final Map<Viewpoint, Boolean> viewpoints;

    public ViewpointsTableLazyCellModifier(Map<Viewpoint, Boolean> viewpoints, TableViewer tableViewer) {
        this.viewpoints = viewpoints;
        this.tableViewer = tableViewer;
    }

    public Object getValue(Object element, String property) {
        Viewpoint viewpoint = (Viewpoint)element;
        Object result = null;
        if (property.equals(ViewpointSelectionDialog.COLUMNS[0])) {
            result = Boolean.FALSE;
            for (Map.Entry<Viewpoint, Boolean> entry : this.viewpoints.entrySet()) {
                if (!entry.getValue().booleanValue() || !EqualityHelper.areEquals((EObject)viewpoint, (EObject)((EObject)entry.getKey()))) continue;
                result = Boolean.TRUE;
                break;
            }
        } else if (!property.equals(ViewpointSelectionDialog.COLUMNS[1])) {
            result = new IdentifiedElementQuery((IdentifiedElement)viewpoint).getLabel();
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        Object objElement = element instanceof Item ? ((Item)element).getData() : element;
        if (property.equals(ViewpointSelectionDialog.COLUMNS[0])) {
            Viewpoint vp = (Viewpoint)objElement;
            Boolean result = Boolean.TRUE.equals(value);
            for (Viewpoint viewpoint : this.viewpoints.keySet()) {
                if (!EqualityHelper.areEquals((EObject)viewpoint, (EObject)vp)) continue;
                this.viewpoints.put(viewpoint, result);
                break;
            }
            this.tableViewer.update((Object)vp, null);
        }
    }

    public boolean canModify(Object element, String property) {
        if (property.equals(ViewpointSelectionDialog.COLUMNS[0])) {
            Viewpoint vp = (Viewpoint)element;
            return !SiriusViewpointManager.INSTANCE.isUnderControl(vp);
        }
        return false;
    }
}

