/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.egf;

import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeBoolean;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.emf.common.util.URI;

public class ContractHelper {
    public static EMFDomain setDomain(FactoryComponent factoryComponent, String contractName, URI uri) {
        Viewpoint viewpoint = factoryComponent.getViewpointContainer().getViewpoint(DomainViewpoint.class);
        if (viewpoint instanceof DomainViewpoint) {
            DomainViewpoint domainViewpoint = (DomainViewpoint)viewpoint;
            for (Domain domain : domainViewpoint.getDomains()) {
                if (!(domain instanceof EMFDomain) || !domain.getName().equals(contractName)) continue;
                EMFDomain domainURI = (EMFDomain)domain;
                domainURI.setUri(uri);
                return domainURI;
            }
        }
        return null;
    }

    public static TypeString setStringContract(FactoryComponent factoryComponent, String contractName, String value) {
        Contract invokedContract = factoryComponent.getContract(contractName);
        Type type = invokedContract.getType();
        if (type instanceof TypeString) {
            TypeString typeString = (TypeString)type;
            typeString.setValue(value);
            return typeString;
        }
        return null;
    }

    public static TypeBoolean setBooleanContract(FactoryComponent factoryComponent, String contractName, boolean value) {
        Contract invokedContract = factoryComponent.getContract(contractName);
        Type type = invokedContract.getType();
        if (type instanceof TypeBoolean) {
            TypeBoolean typeBoolean = (TypeBoolean)type;
            typeBoolean.setValue(Boolean.valueOf(value));
            return typeBoolean;
        }
        return null;
    }
}

