/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RuleSet;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IRuleHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointManager;

public class ViewpointRuleHandler
extends ViewpointManager.ElementHandler
implements IRuleHandler {
    public ViewpointRuleHandler(Viewpoint viewpoint, ViewpointManager mgr) {
        super(viewpoint, mgr);
    }

    @Override
    public void removeRules(List<Rule> rules) {
        for (Rule rule : rules) {
            if (!this.isRemovable((ViewpointElement)rule)) continue;
            EcoreUtil.delete((EObject)rule);
        }
        this.saveModel();
    }

    @Override
    public void createRule(String id) {
        this.createRule(id, null, null);
    }

    @Override
    public void createRule(String id, String type, String implementation) {
        RuleSet set = this.getCurrentRuleSet();
        Rule rule = ViewpointFactory.eINSTANCE.createRule();
        rule.setId(id);
        rule.setType(type);
        rule.setImplementation(implementation);
        rule.setVpid(EcoreUtil.generateUUID());
        set.getNewRules().add((Object)rule);
        this.saveModel();
    }

    private RuleSet getCurrentRuleSet() {
        RuleSet set = this.getViewpoint().getRuleSet();
        if (set == null) {
            set = ViewpointFactory.eINSTANCE.createRuleSet();
            set.setTarget(this.getViewpoint());
            set.setVpid(EcoreUtil.generateUUID());
            this.getViewpoint().setRuleSet(set);
        }
        return set;
    }

    @Override
    public List<ViewpointElement> getElements() {
        ArrayList<ViewpointElement> rules = new ArrayList<ViewpointElement>();
        rules.addAll((Collection<ViewpointElement>)this.getViewpoint().getRules());
        return rules;
    }

    @Override
    public List<ViewpointElement> getElementsFromParents() {
        HashMap<String, ViewpointElement> name2prop = new HashMap<String, ViewpointElement>();
        for (Viewpoint vp : this.getViewpoint().getAllParents()) {
            for (ViewpointElement elt : vp.getRules()) {
                name2prop.put(this.getIdentifier(elt), elt);
            }
        }
        return new ArrayList<ViewpointElement>(name2prop.values());
    }
}

