/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.workspace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ServiceSet;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IServiceHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.WorkspaceManager;

public class ServiceHandler
extends WorkspaceManager.ElementHandler
implements IServiceHandler {
    public ServiceHandler(Viewpoint viewpoint, ResourceManager mgr) {
        super(viewpoint, mgr);
    }

    private ServiceSet createServiceSet() {
        ServiceSet serviceSet = ViewpointFactory.eINSTANCE.createServiceSet();
        serviceSet.setTarget(this.getViewpoint());
        serviceSet.setVpid(EcoreUtil.generateUUID());
        this.getWorkspace().getServiceSets().add((Object)serviceSet);
        return serviceSet;
    }

    @Override
    public void removeServices(List<Service> services) {
        for (Service service : services) {
            if (!this.isRemovable((ViewpointElement)service)) continue;
            ServiceSet set = (ServiceSet)service.eContainer();
            set.getNewServices().remove((Object)service);
        }
        this.saveModel();
    }

    @Override
    public void createService(String id, String name, String type, List<Rule> rules) {
        if (this.getWorkspace() == null) {
            throw new IllegalStateException("no workspace available");
        }
        ServiceSet set = this.getCurrentServiceSet();
        Service service = ViewpointFactory.eINSTANCE.createService();
        set.getNewServices().add((Object)service);
        service.setId(id);
        service.setName(name);
        service.setType(type);
        service.getRelatedRules().addAll(rules);
        service.setVpid(EcoreUtil.generateUUID());
        this.saveModel();
    }

    private ServiceSet getCurrentServiceSet() {
        ServiceSet set = this.getWorkspace().getServiceSet(this.getViewpoint());
        if (set == null) {
            set = this.createServiceSet();
        }
        return set;
    }

    @Override
    public List<ViewpointElement> getElements() {
        ServiceSet set;
        EList toRemove = null;
        EList toAdd = null;
        HashMap<String, ViewpointElement> name2elt = new HashMap<String, ViewpointElement>();
        for (ViewpointElement elt : this.getViewpoint().getServices()) {
            name2elt.put(this.getIdentifier(elt), elt);
        }
        if (this.getWorkspace() != null && (set = this.getWorkspace().getServiceSet(this.getViewpoint())) != null) {
            toRemove = set.getHiddenServices();
            toAdd = set.getNewServices();
        }
        return this.computeElements((List<? extends ViewpointElement>)this.getViewpoint().getServices(), (List<? extends ViewpointElement>)toRemove, (List<? extends ViewpointElement>)toAdd);
    }

    @Override
    public List<ViewpointElement> getElementsFromParents() {
        HashMap<String, ViewpointElement> name2prop = new HashMap<String, ViewpointElement>();
        for (Viewpoint vp : this.getViewpoint().getAllParents()) {
            this.processViewpoint(vp, name2prop);
        }
        this.processViewpoint(this.getViewpoint(), name2prop);
        return new ArrayList<ViewpointElement>(name2prop.values());
    }

    private void processViewpoint(Viewpoint vp, Map<String, ViewpointElement> name2prop) {
        for (ViewpointElement elt : vp.getServices()) {
            name2prop.put(this.getIdentifier(elt), elt);
        }
    }
}

