/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.wizard.AFProjectHelper;

public abstract class AbstractViewpointProjectWizard
extends Wizard
implements INewWizard {
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    protected ISelection selection;
    protected final AFProjectHelper projectHelper;

    protected abstract Viewpoint createModel(String var1, String var2) throws CoreException;

    protected abstract String getProjectName();

    protected abstract String getViewpointName();

    protected abstract String getViewpointShortName();

    protected abstract String getViewpointId();

    public AbstractViewpointProjectWizard(AFProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public boolean performFinish() {
        final String projectName = this.getProjectName();
        final String viewpointName = this.getViewpointName();
        final String viewpointShortName = this.getViewpointShortName();
        final String viewpointId = this.getViewpointId();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("Creating artifacts for extension " + projectName, 4);
                        Viewpoint model = AbstractViewpointProjectWizard.this.createModel(viewpointName, viewpointId);
                        String vpURI = String.valueOf('/') + projectName + "/model/" + viewpointShortName + ".vp";
                        AbstractViewpointProjectWizard.this.createProject(projectName, viewpointName, viewpointId, monitor, model.getVpid(), vpURI);
                        AbstractViewpointProjectWizard.this.saveModel(model, vpURI);
                        monitor.done();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            AD_Log.getDefault().logError((Throwable)e);
            return false;
        }
        return true;
    }

    protected void saveModel(Viewpoint vp, String vpURI) throws CoreException {
        ResourceSetImpl set = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)vpURI, (boolean)false);
        Resource createResource = set.createResource(uri);
        createResource.getContents().add((Object)vp);
        try {
            createResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    protected IProject createProject(String projectName, String viewpointName, String viewpointId, IProgressMonitor monitor, String vpuuid, String vpURI) throws CoreException, IOException {
        return this.projectHelper.createProject(projectName, viewpointName, viewpointId, vpuuid, vpURI, monitor);
    }
}

