/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.sdk.manager;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.polarsys.kitalpha.ad.viewpoint.sdk.Activator;
import org.polarsys.kitalpha.ad.viewpoint.sdk.Messages;
import org.polarsys.kitalpha.ad.viewpoint.sdk.manager.BundleRegistryListener;

public class BundleManager {
    private final Set<String> allManagedBundles = new HashSet<String>();
    private final Map<String, Set<String>> bundle2dependencies = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> bundle2users = new HashMap<String, Set<String>>();
    public static final BundleManager INSTANCE = new BundleManager();

    public void unLoad(String symbolicName) throws BundleException {
        if (this.bundle2users.containsKey(symbolicName) && !this.bundle2users.get(symbolicName).isEmpty()) {
            StringBuilder string = new StringBuilder();
            string.append(Messages.ManageBundle_error_title6);
            for (String user : this.bundle2users.get(symbolicName)) {
                string.append(user).append("\n");
            }
            throw new IllegalStateException(string.toString());
        }
        Bundle bundle = Platform.getBundle((String)symbolicName);
        this.remove(bundle);
    }

    protected void remove(Bundle bundle) throws BundleException {
        bundle.stop(1);
        for (Set<String> users : this.bundle2users.values()) {
            users.remove(bundle.getSymbolicName());
        }
        if (this.bundle2dependencies.containsKey(bundle.getSymbolicName())) {
            for (String dependency : this.bundle2dependencies.get(bundle.getSymbolicName())) {
                Bundle bundle2;
                Set<String> users = this.bundle2users.get(dependency);
                if (users != null && !users.isEmpty() || (bundle2 = Platform.getBundle((String)dependency)) == null) continue;
                this.remove(bundle2);
            }
            this.bundle2dependencies.remove(bundle.getSymbolicName());
        }
    }

    public void load(String symbolicName) throws BundleException, CoreException, InterruptedException, IOException {
        this.allManagedBundles.add(symbolicName);
        BundleRegistryListener listener = new BundleRegistryListener(symbolicName);
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)listener);
        HashSet<Bundle> collector = new HashSet<Bundle>();
        try {
            IPluginModelBase model = PluginRegistry.findModel((String)symbolicName);
            this.load(model.getBundleDescription(), collector);
            this.findBundle(symbolicName);
            BundleContext context = Activator.getContext();
            Bundle systemBundle = context.getBundle(0L);
            FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
            frameworkWiring.refreshBundles(collector, new FrameworkListener[0]);
            listener.waitForEventDispatch();
        }
        finally {
            RegistryFactory.getRegistry().removeListener((IRegistryEventListener)listener);
        }
    }

    private void load(BundleDescription description, Set<Bundle> collector) throws BundleException, CoreException, InterruptedException, IOException {
        String symbolicName = description.getSymbolicName();
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification spec = bundleSpecificationArray[n2];
            BaseDescription supplier = spec.getSupplier();
            if (supplier == null) {
                throw new BundleException(NLS.bind((String)Messages.ManageBundle_error_title7, (Object)spec.getName()));
            }
            String requiredSymbolicName = supplier.getSupplier().getSymbolicName();
            Bundle bundle = Platform.getBundle((String)requiredSymbolicName);
            if (bundle == null || this.allManagedBundles.contains(requiredSymbolicName) && bundle.getState() != 32) {
                bundle = this.findBundle(requiredSymbolicName);
                collector.add(bundle);
                this.load((BundleDescription)supplier, collector);
                this.createLinks(symbolicName, requiredSymbolicName);
            }
            if (this.allManagedBundles.contains(requiredSymbolicName)) {
                collector.add(bundle);
                this.createLinks(symbolicName, requiredSymbolicName);
            }
            ++n2;
        }
    }

    protected Bundle findBundle(String symbolicName) throws BundleException, CoreException, IOException {
        IPluginModelBase model = PluginRegistry.findModel((String)symbolicName);
        if (model instanceof ExternalPluginModel) {
            Bundle bundle = Platform.getBundle((String)symbolicName);
            if (bundle != null) {
                return bundle;
            }
            ExternalPluginModel extModel = (ExternalPluginModel)model;
            return this.installBundle(new File(extModel.getInstallLocation()).toURI());
        }
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject(symbolicName);
        Bundle installBundle = this.installBundle2(project2);
        this.allManagedBundles.add(symbolicName);
        return installBundle;
    }

    private void createLinks(String user, String dependency) {
        if (this.allManagedBundles.contains(dependency) && this.allManagedBundles.contains(user)) {
            Set<String> dependencies = this.bundle2dependencies.get(user);
            if (dependencies == null) {
                dependencies = new HashSet<String>();
                this.bundle2dependencies.put(user, dependencies);
            }
            dependencies.add(dependency);
            Set<String> users = this.bundle2users.get(dependency);
            if (users == null) {
                users = new HashSet<String>();
                this.bundle2users.put(dependency, users);
            }
            users.add(user);
        }
    }

    private Bundle installBundle2(IProject project) throws BundleException, CoreException, IOException {
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(array);
        IJavaProject jProject = JavaCore.create((IProject)project);
        List<String> outputFolders = BundleManager.getStringOutputFolders(jProject);
        HashSet<String> names = new HashSet<String>();
        this.addContent(new File(project.getLocation().toPortableString()), "", "", outputFolders, out, names);
        out.close();
        array.flush();
        array.close();
        String location = "ID->" + this.getLocation(project);
        Bundle bundle = Activator.getContext().getBundle(location);
        if (bundle == null) {
            return Activator.getContext().installBundle(location, (InputStream)new ByteArrayInputStream(array.toByteArray()));
        }
        bundle.update((InputStream)new ByteArrayInputStream(array.toByteArray()));
        return bundle;
    }

    private void addContent(File folder, String path, String zipPath, List<String> outputFolders, ZipOutputStream out, Set<String> names) throws IOException {
        String[] subdirList;
        int buffer = 1024;
        byte[] data = new byte[buffer];
        String[] stringArray = subdirList = folder.list();
        int n = subdirList.length;
        int n2 = 0;
        while (n2 < n) {
            String subzipPath;
            String sd = stringArray[n2];
            File f = new File(folder, sd);
            String subPath = path.equals("") ? sd : String.valueOf(path) + "/" + sd;
            String string = subzipPath = zipPath.equals("") ? sd : String.valueOf(zipPath) + "/" + sd;
            if (f.isDirectory()) {
                if (outputFolders.contains(sd)) {
                    subzipPath = zipPath;
                }
                this.addContent(f, subPath, subzipPath, outputFolders, out, names);
            } else if (!names.contains(subzipPath)) {
                try {
                    Throwable throwable = null;
                    Object var18_20 = null;
                    try (BufferedInputStream origin = new BufferedInputStream(new FileInputStream(f));){
                        int count;
                        ZipEntry entry = new ZipEntry(subzipPath);
                        names.add(subzipPath);
                        out.putNextEntry(entry);
                        while ((count = origin.read(data, 0, buffer)) != -1) {
                            out.write(data, 0, count);
                        }
                        out.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            ++n2;
        }
    }

    private Bundle installBundle(URI uri) throws UnsupportedEncodingException, MalformedURLException, BundleException {
        String location = this.getLocation(uri);
        return Activator.getContext().installBundle(location);
    }

    private String getLocation(IProject project) throws UnsupportedEncodingException, MalformedURLException {
        return this.getLocation(project.getLocationURI());
    }

    private String getLocation(URI uri) throws UnsupportedEncodingException, MalformedURLException {
        return "reference:" + URLDecoder.decode(uri.toURL().toExternalForm(), System.getProperty("file.encoding"));
    }

    public boolean isManaged(String symbolicName) {
        return this.allManagedBundles.contains(symbolicName);
    }

    public boolean isManaged(IProject project) {
        return this.isManaged(project.getName());
    }

    private static List<String> getStringOutputFolders(IJavaProject project) throws CoreException {
        ArrayList<String> outputFoldersAsString = new ArrayList<String>();
        if (!project.exists()) {
            return outputFoldersAsString;
        }
        List<IFolder> outputFolders = BundleManager.getOutputFolders(project);
        for (IFolder outputFolder : outputFolders) {
            outputFoldersAsString.add(outputFolder.getFullPath().removeFirstSegments(1).toString());
        }
        return outputFoldersAsString;
    }

    private static List<IFolder> getOutputFolders(IJavaProject project) throws CoreException {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        if (project == null || !project.exists()) {
            return folders;
        }
        IFolder folder = BundleManager.getFolder(project.getOutputLocation());
        if (folder != null) {
            folders.add(folder);
        }
        IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder innerFolder;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (innerFolder = BundleManager.getFolder(entry.getOutputLocation())) != null) {
                folders.add(innerFolder);
            }
            ++n2;
        }
        return folders;
    }

    private static IFolder getFolder(IPath folderRelativePath) {
        if (folderRelativePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(folderRelativePath);
    }
}

