/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ModelReuseHelper {
    private static final String METADATA_KEYWORD = "useMetadata";
    private static final String MODELREUSE_SCHEME_PREFIX = "modelreuse";

    public static URI createModelReuseURI(Resource resource, boolean manageMetadata) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(MODELREUSE_SCHEME_PREFIX).append(":/");
        sb.append("id=").append(URI.encodeSegment((String)resource.getId(), (boolean)false));
        if (manageMetadata) {
            sb.append("/").append(URI.encodeSegment((String)METADATA_KEYWORD, (boolean)false));
        }
        return URI.createURI((String)sb.toString());
    }

    public static URI[] createModelReuseURI(Resource resource) {
        if (resource.getMetadataPath() != null) {
            return new URI[]{ModelReuseHelper.createModelReuseURI(resource, false), ModelReuseHelper.createModelReuseURI(resource, true)};
        }
        return new URI[]{ModelReuseHelper.createModelReuseURI(resource, false)};
    }

    public static URI createMetatadaURI(URI uri) {
        if (ModelReuseHelper.hasModelReuseScheme(uri)) {
            if (uri.path().contains(METADATA_KEYWORD)) {
                return uri;
            }
            return uri.appendSegment(METADATA_KEYWORD);
        }
        return uri;
    }

    public static boolean hasModelReuseScheme(URI uri) {
        return uri.scheme().equals(MODELREUSE_SCHEME_PREFIX);
    }

    public static URI createModelReuseURI(SearchCriteria criteria) {
        return ModelReuseHelper.createModelReuseURI(criteria, false);
    }

    public static URI createModelReuseMetadataURI(SearchCriteria criteria) {
        return ModelReuseHelper.createModelReuseURI(criteria, true);
    }

    private static URI createModelReuseURI(SearchCriteria criteria, boolean manageMetadata) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(MODELREUSE_SCHEME_PREFIX).append(":/");
        if (criteria.getId() != null && !criteria.getId().isEmpty()) {
            sb.append("id=").append(URI.encodeSegment((String)criteria.getId(), (boolean)false)).append('/');
        }
        if (criteria.getName() != null && !criteria.getName().isEmpty()) {
            sb.append("name=").append(URI.encodeSegment((String)criteria.getName(), (boolean)false)).append('/');
        }
        if (criteria.getDomain() != null && !criteria.getDomain().isEmpty()) {
            sb.append("domain=").append(URI.encodeSegment((String)criteria.getDomain(), (boolean)false)).append('/');
        }
        if (criteria.getVersion() != null && !criteria.getVersion().isEmpty()) {
            sb.append("version=").append(URI.encodeSegment((String)criteria.getVersion(), (boolean)false)).append('/');
        }
        if (criteria.getTags() != null && !criteria.getTags().isEmpty()) {
            sb.append("tags=");
            for (String tag : criteria.getTags()) {
                sb.append(URI.encodeSegment((String)tag, (boolean)false)).append(',');
            }
            sb.deleteCharAt(sb.length() - 1).append("/");
        }
        if (manageMetadata) {
            sb.append(URI.encodeSegment((String)METADATA_KEYWORD, (boolean)false)).append("/");
        }
        return URI.createURI((String)sb.toString());
    }

    public static List<URI> findModelsURIAccordingToCriteria(SearchCriteria criteria) {
        ArrayList<URI> foundModels = new ArrayList<URI>();
        List<Resource> resourceSelected = ModelReuseHelper.findModelsAccordingToCriteria(criteria);
        for (Resource resource : resourceSelected) {
            URI modelResourceURI = null;
            modelResourceURI = ModelReuseHelper.createModelReuseURI(resource, false);
            foundModels.add(modelResourceURI);
        }
        return foundModels;
    }

    public static List<Resource> findModelsAccordingToCriteria(SearchCriteria criteria) {
        Resource[] resourceSelectedPlatform;
        Resource[] resourceSelectedWorkspace;
        ResourceHelper resourceHelperPlatform = ResourceReuse.createPlatformHelper();
        ResourceHelper resourceHelperWorkspace = ResourceReuse.createWorkspaceHelper();
        ArrayList<Resource> resourceSelected = new ArrayList<Resource>();
        Resource[] resourceArray = resourceSelectedWorkspace = resourceHelperWorkspace.getResources(criteria);
        int n = resourceSelectedWorkspace.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            resourceSelected.add(resource);
            ++n2;
        }
        Resource[] resourceArray2 = resourceSelectedPlatform = resourceHelperPlatform.getResources(criteria);
        int n3 = resourceSelectedPlatform.length;
        n = 0;
        while (n < n3) {
            Resource resource = resourceArray2[n];
            boolean resourceAlreadyFound = false;
            for (Resource resourceInResourceSelected : resourceSelected) {
                if (!resourceInResourceSelected.getId().equals(resource.getId())) continue;
                resourceAlreadyFound = true;
            }
            if (!resourceAlreadyFound) {
                resourceSelected.add(resource);
            }
            ++n;
        }
        return resourceSelected;
    }

    private ModelReuseHelper() {
    }
}

