/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.attachment.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.setup.ComparisonSetupManager;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.model.attachment.ui.Activator;
import org.polarsys.kitalpha.model.attachment.ui.Messages;
import org.polarsys.kitalpha.model.attachment.ui.merge.MergeCommand;
import org.polarsys.kitalpha.model.attachment.ui.merge.OpenConflictEditorRunnable;
import org.polarsys.kitalpha.model.attachment.ui.wizard.ModelPage;
import org.polarsys.kitalpha.model.attachment.ui.wizard.ViewpointPage;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;

public class AttachmentWizard
extends Wizard {
    private List<IFile> files;
    private ModelPage modelPage;
    ViewpointPage viewpointPage;

    public AttachmentWizard(List<IFile> files) {
        this.files = files;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.wizard_title);
    }

    private ModelCommand getCommand(String id) throws CoreException {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.model.common.commands.definition");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            String attribute = elt.getAttribute("id");
            if (attribute != null && id.equals(attribute)) {
                return (ModelCommand)elt.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }

    public void addPages() {
        this.modelPage = new ModelPage(this.files);
        this.addPage((IWizardPage)this.modelPage);
        this.viewpointPage = new ViewpointPage();
        this.addPage((IWizardPage)this.viewpointPage);
    }

    public boolean performFinish() {
        ComparisonSetupManager manager = EMFDiffMergeUIPlugin.getDefault().getSetupManager();
        ComparisonSetup setup = manager.createComparisonSetup((Object)this.modelPage.getTargetFile(), (Object)this.modelPage.getSourceFile(), (Object)this.modelPage.getAncestorFile());
        IComparisonMethodFactory comparisonMethodFactory = (IComparisonMethodFactory)setup.getApplicableComparisonMethodFactories().get(0);
        final IComparisonMethod method = comparisonMethodFactory.createComparisonMethod(setup.getScopeDefinition(Role.TARGET), setup.getScopeDefinition(Role.REFERENCE), setup.getScopeDefinition(Role.ANCESTOR));
        final EditingDomain domain = method.getEditingDomain();
        final ArrayList<IDifference> conflicts = new ArrayList<IDifference>();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        URI uri = URI.createPlatformResourceURI((String)AttachmentWizard.this.modelPage.getTargetFile().getFullPath().toString(), (boolean)false);
                        Resource resource = domain.getResourceSet().getResource(uri, true);
                        EcoreUtil.resolveAll((Resource)resource);
                        AttachmentWizard.this.getCommand("org.polarsys.kitalpha.model.common.commands.contrib.detachment.checkFileResourceAttributes").exec(null, resource, monitor);
                        AttachmentWizard.this.getCommand("org.polarsys.kitalpha.model.actions.contrib.detachment.backupAndSave").exec(null, resource, monitor);
                        domain.getCommandStack().execute((Command)new MergeCommand((TransactionalEditingDomain)domain, method, AttachmentWizard.this.viewpointPage.analysisResult.getSelectedUris(), conflicts, monitor));
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
            if (!conflicts.isEmpty()) {
                this.getContainer().getShell().getDisplay().asyncExec((Runnable)new OpenConflictEditorRunnable(method, conflicts));
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.error_dialog_title, (String)realException.getMessage());
            Activator.LOG.logError((Throwable)e);
            return false;
        }
        return true;
    }
}

