/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.impl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.AfdslResourceCreator;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.impl.AfdslFileCreationPage;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.impl.AfdslFileSecondPage;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.impl.AfdslFileThirdPage;
import org.polarsys.kitalpha.ad.af.dsl.services.cs.text.wizards.messages.Messages;
import org.polarsys.kitalpha.ad.af.dsl.services.preference.helper.AFRootProjectNamePreferencesHelper;
import org.polarsys.kitalpha.ad.af.dsl.servicies.project.ui.NewAFSpecProject;

public class AfdslFileWizard
extends NewAFSpecProject
implements INewWizard {
    private AfdslFileCreationPage firstPage;
    private AfdslFileSecondPage secondPage;
    private AfdslFileThirdPage thirdPage;
    private IStructuredSelection selection;
    private AfdslResourceCreator delegate;

    public AfdslFileCreationPage getFirstPage() {
        return this.firstPage;
    }

    public AfdslFileSecondPage getSecondPage() {
        return this.secondPage;
    }

    public AfdslFileThirdPage getThirdPage() {
        return this.thirdPage;
    }

    public AfdslFileWizard() {
        this.setWindowTitle(Messages.AfdslNewFile_AfdslFileWizard);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        IPath containerPath = this.firstPage.getContainerFullPath();
        IPath filePath = containerPath.append(this.firstPage.getFileName());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        String projectName = filePath.segment(0);
        String rootProjectName = AFRootProjectNamePreferencesHelper.getCustomizedValue();
        this.setAfRootProjectName(rootProjectName);
        this.setAfSpecificationProjectName(projectName);
        if (!file.exists()) {
            this.delegate = new AfdslResourceCreator(file.getName(), this.getAfShortName(), this.getAfRootProjectName(), this.getAfSpecificationProjectName(), this.secondPage.getSelectedViewpoint());
            return this.delegate.createResourceAndOpenEditor(file);
        }
        return false;
    }

    public IFile createNewFile() {
        return this.firstPage.createNewFile();
    }

    public void addPages() {
        this.firstPage = new AfdslFileCreationPage(this.selection);
        this.addPage((IWizardPage)this.firstPage);
        this.secondPage = new AfdslFileSecondPage((ISelection)this.selection);
        this.secondPage.setTitle(Messages.AfdslNewFileSecondPage_InitializeProperties);
        this.secondPage.setDescription(String.valueOf(Messages.AfdslNewFileCreationPage_CreateAfdslFileFromScratch) + " (2/3)");
        this.addPage((IWizardPage)this.secondPage);
    }
}

