/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.ui.api;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.polarsys.kitalpha.cadence.core.api.CadenceLauncher;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.cadence.ui.Activator;
import org.polarsys.kitalpha.cadence.ui.internal.CadenceHelper;

public class CadenceUiRegistry {
    public static void launch(ILaunchConfiguration configuration, String workflowid, String workflowElementid, Map<String, GenericParameter<?>> params) {
        CadenceUiRegistry.launch(configuration, workflowid, workflowElementid, params, null);
    }

    public static void launch(ILaunchConfiguration configuration, String workflowid, String workflowElementid, Map<String, GenericParameter<?>> params, IProgressMonitor monitor) {
        try {
            WorkflowActivityParameter workflowParameters = CadenceUiRegistry.getActivities(configuration, workflowid, workflowElementid);
            for (String activityID : workflowParameters.getActivitiesID()) {
                ActivityParameters activityparameters = workflowParameters.getActivityParameters(activityID);
                Set<Map.Entry<String, GenericParameter<?>>> entrySet = params.entrySet();
                for (Map.Entry<String, GenericParameter<?>> entry : entrySet) {
                    activityparameters.addParameter(entry.getValue());
                }
            }
            CadenceLauncher.cadence((String)workflowid, (String)workflowElementid, (WorkflowActivityParameter)workflowParameters, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            ILog log = Activator.getDefault().getLog();
            log.log((IStatus)new Status(4, "org.polarsys.kitalpha.cadence.ui", e.getMessage()));
        }
    }

    public static WorkflowActivityParameter getActivities(ILaunchConfiguration configuration, String workflowid, String workflowElementid) {
        WorkflowActivityParameter res = CadenceHelper.getActivitiesFromLauchConfiguration(configuration, workflowElementid);
        return res;
    }
}

