/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;

public class AFProjectHelper {
    protected final Set<String> requiredBundles = new HashSet<String>();

    public AFProjectHelper() {
        this.requiredBundles.add("org.polarsys.kitalpha.ad.viewpoint.ui");
    }

    public IProject createProject(String name, String vpName, String vpId, String vpuuid, String vpURI, IProgressMonitor monitor) throws CoreException, IOException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            project.create(monitor);
        }
        project.open(monitor);
        this.addNatures(project, monitor);
        this.setupJava(project, monitor);
        IFolder metaFolder = this.createFolder(project, "META-INF", monitor);
        this.createFolder(project, "model", monitor);
        this.createManifest(metaFolder, project.getName(), monitor);
        this.createBuildProperties(project, monitor);
        this.createPluginXML(project, vpName, vpId, vpuuid, vpURI, monitor);
        this.createIcon(project, monitor);
        return project;
    }

    protected void createIcon(IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        URL entry = Activator.getDefault().getBundle().getEntry("icons/view.gif");
        IFolder iconFolder = this.createFolder(project, "icons", monitor);
        IFile iconFile = iconFolder.getFile((IPath)new Path("view.gif"));
        this.writeFile(entry.openStream(), iconFile, monitor);
    }

    protected void createPluginXML(IProject project, String vpName, String vpId, String vpuuid, String vpURI, IProgressMonitor monitor) throws CoreException {
        IFile xml = project.getFile("plugin.xml");
        StringBuffer contents = new StringBuffer();
        String viewId = String.valueOf(vpId) + ".view";
        contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        contents.append("<?eclipse version=\"3.4\"?>\n");
        contents.append("<plugin>\n");
        contents.append("\t<extension\n");
        contents.append("\t     point=\"org.eclipse.ui.views\">\n");
        contents.append("\t  <view\n");
        contents.append("\t        name=\"").append(vpName).append("\"\n");
        contents.append("\t        icon=\"icons/view.gif\"\n");
        contents.append("\t        category=\"org.polarsys.kitalpha.view.additional.category\"\n");
        contents.append("\t        class=\"org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointView\"\n");
        contents.append("\t        id=\"").append(viewId).append("\"\n");
        contents.append("\t        resourceId=\"").append(vpId).append("\"/>\n");
        contents.append("\t</extension>\n");
        contents.append("\t<extension\n");
        contents.append("\t     point=\"org.polarsys.kitalpha.resourcereuse.resources\">\n");
        contents.append("\t  <resource\n");
        contents.append("\t        domain=\"AF\"\n");
        contents.append("\t        id=\"").append(vpId).append("\"\n");
        contents.append("\t        tags=\"vp\"\n");
        contents.append("\t        name=\"").append(vpName).append("\"\n");
        contents.append("\t        path=\"").append(vpURI).append('#').append(vpuuid).append("\"/>\n");
        contents.append("\t</extension>\n");
        contents.append("\t<extension\n");
        contents.append("\t     point=\"org.eclipse.ui.propertiesView\">\n");
        contents.append("\t        <excludeSources\n");
        contents.append("\t           id=\"").append(viewId).append("\">\n");
        contents.append("\t        </excludeSources>\n");
        contents.append("\t</extension>\n");
        contents.append("</plugin>\n");
        contents.append("\n");
        ByteArrayInputStream source = new ByteArrayInputStream(contents.toString().getBytes());
        this.writeFile(source, xml, monitor);
    }

    protected void addNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] newNatures = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.polarsys.kitalpha.ad.common.VPnature"};
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    protected void setupJava(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder srcFolder = this.createFolder(project, "src", monitor);
        IFolder binFolder = this.createFolder(project, "bin", monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(binFolder.getFullPath(), monitor);
        IClasspathEntry[] entries = new IClasspathEntry[3];
        String executionEnvironment = "J2SE-1.5";
        ClasspathComputer.setComplianceOptions((IJavaProject)javaProject, (String)executionEnvironment);
        entries[0] = ClasspathComputer.createJREEntry((String)executionEnvironment);
        entries[1] = ClasspathComputer.createContainerEntry();
        entries[2] = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
        javaProject.setRawClasspath(entries, monitor);
    }

    protected void createManifest(IFolder metaFolder, String name, IProgressMonitor monitor) throws CoreException {
        IFile manifest = metaFolder.getFile("MANIFEST.MF");
        StringBuffer contents = new StringBuffer();
        contents.append("Manifest-Version: 1.0\n");
        contents.append("Bundle-ManifestVersion: 2\n");
        contents.append("Bundle-Name: " + name + "\n");
        contents.append("Bundle-SymbolicName: " + name + ";singleton:=true\n");
        contents.append("Bundle-Version: 1.0.0.qualifier\n");
        contents.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
        if (!this.requiredBundles.isEmpty()) {
            Iterator<String> iterator = this.requiredBundles.iterator();
            contents.append("Require-Bundle: ").append(iterator.next()).append(iterator.hasNext() ? ",\n" : "\n");
            while (iterator.hasNext()) {
                contents.append(" ").append(iterator.next()).append(iterator.hasNext() ? ",\n" : "\n");
            }
        }
        contents.append("\n");
        ByteArrayInputStream source = new ByteArrayInputStream(contents.toString().getBytes());
        this.writeFile(source, manifest, monitor);
    }

    protected void createBuildProperties(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile buildProperties = project.getFile("build.properties");
        StringBuffer contents = new StringBuffer();
        contents.append("source.. = src/\n");
        contents.append("output.. = bin/\n");
        contents.append("bin.includes = META-INF/,\\\n");
        contents.append("\t\t\t\t.,\\\n");
        contents.append("\t\t\t\tmodel/");
        ByteArrayInputStream source = new ByteArrayInputStream(contents.toString().getBytes());
        this.writeFile(source, buildProperties, monitor);
    }

    protected IFolder createFolder(IProject project, String name, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getFolder(name);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        return folder;
    }

    protected void writeFile(InputStream source, IFile manifest, IProgressMonitor monitor) throws CoreException {
        if (manifest.exists()) {
            manifest.setContents(source, 3, monitor);
        } else {
            manifest.create(source, false, null);
        }
    }
}

