/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.persistence;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.persistence.PersistenceHelper;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.polarsys.kitalpha.massactions.core.persistence.MAProperties;

public class CustomPersistenceDialogCommandHandler
extends DisplayPersistenceDialogCommandHandler {
    private Set<String> validClasses;
    private MAProperties originalProperties;
    private boolean dirtyState;

    public CustomPersistenceDialogCommandHandler(MAProperties properties, NatTable natTable, Set<String> validClasses) {
        super((Properties)properties, natTable);
        this.validClasses = validClasses;
        this.originalProperties = properties;
        this.setDirtyState(false);
        this.initializeData();
        this.initializeListeners();
    }

    private void initializeData() {
        MAProperties validProperties = this.originalProperties.getValidProperties(this.validClasses);
        this.setProperties(validProperties);
    }

    public void update(Set<String> currentClasses) {
        if (this.isDirtyState()) {
            this.originalProperties.putAll((Map<?, ?>)this.getProperties());
        }
        this.validClasses = currentClasses;
        this.initializeData();
    }

    public MAProperties getProperties() {
        return (MAProperties)super.getProperties();
    }

    private void initializeListeners() {
        this.addStateChangeListener(event -> {
            this.setDirtyState(true);
            switch (event.getType()) {
                case CREATE: {
                    this.getProperties().setCurentValidClasses(this.validClasses);
                    break;
                }
                case DELETE: {
                    PersistenceHelper.deleteState((String)event.getViewConfigName(), (Properties)this.originalProperties);
                    break;
                }
            }
        });
    }

    public void saveState() {
        if (this.isDirtyState()) {
            this.originalProperties.putAll((Map<?, ?>)this.getProperties());
            this.originalProperties.save();
            this.setDirtyState(false);
        }
    }

    private boolean isDirtyState() {
        return this.dirtyState;
    }

    private void setDirtyState(boolean dirtyState) {
        this.dirtyState = dirtyState;
    }
}

