/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.GeneratorTypeWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.GeneratorWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.RefineryWidget;
import org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.composer.StrategyWidget;

public class ComposerTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Composer";
    private final GeneratorTypeWidget typeWidget = new GeneratorTypeWidget(this);
    private final StrategyWidget strategyWidget = new StrategyWidget(this);
    private final RefineryWidget refineryWidget = new RefineryWidget(this);
    private final GeneratorWidget generatorWidget = new GeneratorWidget(this);

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topLayout.numColumns = 1;
        topLayout.marginTop = 10;
        topLayout.marginLeft = 10;
        topLayout.marginRight = 10;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.typeWidget.createContents(comp);
        this.strategyWidget.createContents(comp);
        this.refineryWidget.createContents(comp);
        this.generatorWidget.createContents(comp);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        try {
            this.setGlobalNsUri(workingCopy.getAttribute("allocation_uri", ""));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        String img = "icons/composer.png";
        ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"org.polarsys.kitalpha.composer.ui", (String)img);
        return descriptor.createImage();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.typeWidget.initializeFrom(configuration);
        this.strategyWidget.initializeFrom(configuration);
        this.refineryWidget.initializeFrom(configuration);
        this.generatorWidget.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.typeWidget.performApply(configuration);
        this.strategyWidget.performApply(configuration);
        this.refineryWidget.performApply(configuration);
        this.generatorWidget.performApply(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public Shell getShell() {
        return super.getShell();
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void update() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public final void setGlobalNsUri(String nsUri_p) {
        this.strategyWidget.setNsUri(nsUri_p);
        this.refineryWidget.setNsUri(nsUri_p);
        this.generatorWidget.setNsUri(nsUri_p);
    }
}

