/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.unknownreferences.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.unknownreferences.Messages;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidDMapping;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidDSemanticDiagram;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidDTable;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidDView;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidEReferences;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidFilterDescription;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.InvalidLayer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.MissingEPackage;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;

public class UnknownreferencesCleanCommand
extends ModelCommand {
    Logger LOGGER = Logger.getLogger(UnknownreferencesCleanCommand.class);

    private ECrossReferenceAdapter installCrossReferencer(Resource resource) {
        EList eAdapters = resource.getResourceSet().eAdapters();
        boolean containsECrossReferenceAdapter = false;
        for (Adapter adapter : eAdapters) {
            if (!(adapter instanceof ECrossReferenceAdapter)) continue;
            containsECrossReferenceAdapter = true;
            return (ECrossReferenceAdapter)adapter;
        }
        if (!containsECrossReferenceAdapter) {
            ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter();
            resource.getResourceSet().eAdapters().add((Object)crossReferenceAdapter);
            return crossReferenceAdapter;
        }
        return null;
    }

    public void exec(ModelScrutinyRegistry analysis, Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        ECrossReferenceAdapter crossReferenceAdapter = this.installCrossReferencer(resource);
        TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((ResourceSet)resource.getResourceSet());
        try {
            ModelScrutinyRegistry.RegistryElement regElt = analysis.getRegistryElement(this.getModelAnalysisID());
            monitor.beginTask(Messages.CLEAN_UNKNOWNREFERENCE_TASK, 1);
            for (IScrutinize finder : regElt.getFinders()) {
                RecordingCommand command;
                RecordingCommand remove;
                DDiagram dDiagram;
                if (finder instanceof InvalidDMapping) {
                    monitor.subTask(Messages.CLEAN_INVALID_MAPPINGS);
                    InvalidDMapping invalidDMappings = (InvalidDMapping)finder;
                    for (DRepresentationElement dRepresentationElement : invalidDMappings.getAnalysisResult()) {
                        if (ed != null) {
                            Command remove2 = RemoveCommand.create((EditingDomain)ed, (Object)dRepresentationElement);
                            if (!remove2.canExecute()) continue;
                            ed.getCommandStack().execute(remove2);
                            continue;
                        }
                        EcoreUtil.remove((EObject)dRepresentationElement);
                    }
                }
                if (finder instanceof InvalidDView) {
                    monitor.subTask(Messages.CLEAN_INVALID_REPRESENTATION_CONTAINER);
                    InvalidDView invalidDRepresentationContainer = (InvalidDView)finder;
                    for (DView dView : invalidDRepresentationContainer.getAnalysisResult()) {
                        if (ed != null) {
                            Command remove2 = DeleteCommand.create((EditingDomain)ed, (Object)dView);
                            if (!remove2.canExecute()) continue;
                            ed.getCommandStack().execute(remove2);
                            continue;
                        }
                        EcoreUtil.delete((EObject)dView);
                    }
                }
                if (finder instanceof InvalidFilterDescription) {
                    monitor.subTask(Messages.CLEAN_INVALID_FILTER_DESCRIPTION);
                    InvalidFilterDescription invalidFilterDescription = (InvalidFilterDescription)finder;
                    for (final FilterDescription filterDescription : invalidFilterDescription.getAnalysisResult()) {
                        for (EStructuralFeature.Setting setting : crossReferenceAdapter.getInverseReferences((EObject)filterDescription)) {
                            if (!setting.getEStructuralFeature().equals(DiagramPackage.eINSTANCE.getDDiagram_ActivatedFilters())) continue;
                            dDiagram = (DDiagram)setting.getEObject();
                            if (ed != null) {
                                remove = new RecordingCommand(ed){

                                    protected void doExecute() {
                                        dDiagram.getActivatedFilters().remove((Object)filterDescription);
                                    }
                                };
                                if (!remove.canExecute()) continue;
                                ed.getCommandStack().execute((Command)remove);
                                continue;
                            }
                            dDiagram.getActivatedFilters().remove((Object)filterDescription);
                        }
                    }
                }
                if (finder instanceof InvalidLayer) {
                    monitor.subTask(Messages.CLEAN_INVALID_LAYER);
                    InvalidLayer invalidLayer = (InvalidLayer)finder;
                    for (final Layer layer : invalidLayer.getAnalysisResult()) {
                        for (EStructuralFeature.Setting setting : crossReferenceAdapter.getInverseReferences((EObject)layer)) {
                            if (!setting.getEStructuralFeature().equals(DiagramPackage.eINSTANCE.getDDiagram_ActivatedLayers())) continue;
                            dDiagram = (DDiagram)setting.getEObject();
                            if (ed != null) {
                                remove = new RecordingCommand(ed){

                                    protected void doExecute() {
                                        dDiagram.getActivatedLayers().remove((Object)layer);
                                    }
                                };
                                if (!remove.canExecute()) continue;
                                ed.getCommandStack().execute((Command)remove);
                                continue;
                            }
                            dDiagram.getActivatedLayers().remove((Object)layer);
                        }
                    }
                }
                if (finder instanceof MissingEPackage) {
                    monitor.subTask(Messages.CLEAN_MISSING_EPACKAGE);
                    MissingEPackage missingEPackage = (MissingEPackage)finder;
                    for (AnyType anyType : missingEPackage.getAnalysisResult().getAnyTypes()) {
                        if (ed != null) {
                            final AnyType t = anyType;
                            RecordingCommand cmd = new RecordingCommand(ed){

                                protected void doExecute() {
                                    EcoreUtil.remove((EObject)t);
                                }
                            };
                            if (!cmd.canExecute()) continue;
                            ed.getCommandStack().execute((Command)cmd);
                            continue;
                        }
                        EcoreUtil.delete((EObject)anyType, (boolean)true);
                    }
                    for (XMLResource xMLResource : missingEPackage.getAnalysisResult().getXmlResources()) {
                        xMLResource.getEObjectToExtensionMap().clear();
                    }
                }
                if (finder instanceof InvalidEReferences) {
                    monitor.subTask("Clean Invalid EReferences");
                    InvalidEReferences invalidEReferences = (InvalidEReferences)finder;
                    for (Map.Entry entry : invalidEReferences.getAnalysisResult().entrySet()) {
                        EObject key = (EObject)entry.getKey();
                        List eReferences = (List)entry.getValue();
                        for (EReference r : eReferences) {
                            this.clean(ed, key, r);
                        }
                    }
                }
                if (finder instanceof InvalidDTable) {
                    monitor.subTask("Clean DTables");
                    InvalidDTable invalidDTable = (InvalidDTable)finder;
                    final Set set = invalidDTable.getAnalysisResult();
                    if (ed != null) {
                        command = new RecordingCommand(ed){

                            protected void doExecute() {
                                UnknownreferencesCleanCommand.this.deleteTables(set);
                            }
                        };
                        if (command.canExecute()) {
                            ed.getCommandStack().execute((Command)command);
                        }
                    } else {
                        this.deleteTables(set);
                    }
                }
                if (!(finder instanceof InvalidDSemanticDiagram)) continue;
                monitor.subTask("Clean Diagram");
                InvalidDSemanticDiagram invalidDiagram = (InvalidDSemanticDiagram)finder;
                final Set set = invalidDiagram.getAnalysisResult();
                if (ed != null) {
                    command = new RecordingCommand(ed){

                        protected void doExecute() {
                            set.stream().forEach(diag -> {
                                boolean bl = diag.eResource().getContents().remove(diag);
                            });
                        }
                    };
                    if (!command.canExecute()) continue;
                    ed.getCommandStack().execute((Command)command);
                    continue;
                }
                set.stream().forEach(diag -> {
                    boolean bl = diag.eResource().getContents().remove(diag);
                });
            }
        }
        catch (ModelScrutinyException e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        monitor.worked(1);
        monitor.done();
    }

    private void deleteTables(Set<DTable> tables) {
        for (DTable table : tables) {
            EcoreUtil.remove((EObject)table);
        }
    }

    private void clean(TransactionalEditingDomain ed, final EObject key, final EReference r) {
        block5: {
            final Object value = key.eGet((EStructuralFeature)r);
            try {
                if (ed != null) {
                    RecordingCommand cmd = new RecordingCommand(ed){

                        protected void doExecute() {
                            if (r.isUnsettable()) {
                                key.eUnset((EStructuralFeature)r);
                                EcoreUtil.delete((EObject)((EObject)value));
                            }
                        }
                    };
                    if (cmd.canExecute()) {
                        ed.getCommandStack().execute((Command)cmd);
                    }
                } else {
                    key.eUnset((EStructuralFeature)r);
                    EcoreUtil.remove((EObject)key, (EStructuralFeature)r, (Object)value);
                }
            }
            catch (Exception exception) {
                EReference eContainmentFeature = key.eContainmentFeature();
                if (eContainmentFeature == null || key.eContainer() == null || key.equals(EcoreUtil.getRootContainer((EObject)key))) break block5;
                EcoreUtil.remove((EObject)key.eContainer(), (EStructuralFeature)eContainmentFeature, (Object)key);
            }
        }
    }
}

