/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.metadata.helpers;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;

public class LibraryHelper {
    public static void add(ResourceSet set, URI mainModel, URI libModel) {
        URI mainMetadataURI = MetadataHelper.getExpectedMetadataStorageURI(mainModel);
        URI libMetadataURI = MetadataHelper.getExpectedMetadataStorageURI(libModel);
        Metadata mainMetadata = null;
        Metadata libMetadata = null;
        Resource mainMetadataRes = set.getResource(mainMetadataURI, true);
        if (!mainMetadataRes.getContents().isEmpty()) {
            mainMetadata = (Metadata)mainMetadataRes.getContents().get(0);
        }
        Resource libMetadataRes = null;
        try {
            libMetadataRes = set.getResource(libMetadataURI, true);
            if (!libMetadataRes.getContents().isEmpty()) {
                libMetadata = (Metadata)libMetadataRes.getContents().get(0);
            }
        }
        catch (Exception e) {
            libMetadataRes = set.getResource(libMetadataURI, false);
            if (libMetadataRes != null && libMetadataRes.getContents().isEmpty()) {
                libMetadataRes.unload();
                set.getResources().remove((Object)libMetadataRes);
            }
            throw new NoMetadataException("Cannot find metadata from lib model", e);
        }
        mainMetadata.getAdditionalMetadata().add(libMetadata);
    }

    public static void remove(ResourceSet set, URI mainModel, URI libModel) {
        URI mainMetadataURI = MetadataHelper.getExpectedMetadataStorageURI(mainModel);
        URI libMetadataURI = MetadataHelper.getExpectedMetadataStorageURI(libModel);
        Metadata mainMetadata = null;
        Metadata libMetadata = null;
        Resource mainMetadataRes = set.getResource(mainMetadataURI, true);
        if (!mainMetadataRes.getContents().isEmpty()) {
            mainMetadata = (Metadata)mainMetadataRes.getContents().get(0);
        }
        Resource libMetadataRes = null;
        try {
            libMetadataRes = set.getResource(libMetadataURI, true);
            if (!libMetadataRes.getContents().isEmpty()) {
                libMetadata = (Metadata)libMetadataRes.getContents().get(0);
            }
        }
        catch (Exception e) {
            libMetadataRes = set.getResource(libMetadataURI, false);
            if (libMetadataRes != null && libMetadataRes.getContents().isEmpty()) {
                libMetadataRes.unload();
                set.getResources().remove((Object)libMetadataRes);
            }
            throw new NoMetadataException("Cannot find metadata from lib model", e);
        }
        mainMetadata.getAdditionalMetadata().remove(libMetadata);
    }

    public static class NoMetadataException
    extends RuntimeException {
        private static final long serialVersionUID = 6289563783712353541L;

        public NoMetadataException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

